/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.facet;

import com.intellij.dmserver.artifacts.ManifestManager;
import com.intellij.dmserver.facet.DMBundleFacet;
import com.intellij.dmserver.facet.DMCompositeFacet;
import com.intellij.dmserver.facet.DMCompositeFacetConfiguration;
import com.intellij.dmserver.facet.DMCompositeType;
import com.intellij.dmserver.facet.DMConfigFacet;
import com.intellij.dmserver.facet.DMConfigFacetConfiguration;
import com.intellij.dmserver.facet.DMFacetsSwitch;
import com.intellij.dmserver.facet.DMUnitDescriptor;
import com.intellij.dmserver.facet.DMUnitType;
import com.intellij.dmserver.util.VersionUtils;
import java.util.HashMap;
import java.util.Map;

public class DMUnitDescriptorProvider
extends DMFacetsSwitch<DMUnitDescriptor> {
    private static final Map<DMCompositeType, DMUnitType> ourComposite2UnitType = new HashMap<DMCompositeType, DMUnitType>();
    private static final DMUnitDescriptorProvider ourInstance;

    public static DMUnitDescriptorProvider getInstance() {
        return ourInstance;
    }

    private DMUnitDescriptorProvider() {
    }

    @Override
    protected DMUnitDescriptor doProcessBundleFacet(DMBundleFacet bundleFacet) {
        ManifestManager.FileWrapper manifestFileWrapper = ManifestManager.getBundleInstance().findManifest(bundleFacet.getModule());
        if (manifestFileWrapper == null) {
            return null;
        }
        return new DMUnitDescriptor(DMUnitType.BUNDLE, manifestFileWrapper.getSymbolicName(), manifestFileWrapper.getVersion());
    }

    @Override
    protected DMUnitDescriptor doProcessCompositeFacet(DMCompositeFacet compositeFacet) {
        DMCompositeFacetConfiguration configuration = compositeFacet.getConfigurationImpl();
        return new DMUnitDescriptor(ourComposite2UnitType.get((Object)configuration.getCompositeType()), configuration.getName(compositeFacet.getModule()), configuration.getVersion());
    }

    @Override
    protected DMUnitDescriptor doProcessConfigFacet(DMConfigFacet configFacet) {
        DMConfigFacetConfiguration configuration = configFacet.getConfigurationImpl();
        return new DMUnitDescriptor(DMUnitType.CONFIG, configuration.getName(configFacet.getModule()), VersionUtils.emptyRange.toString());
    }

    static {
        ourComposite2UnitType.put(DMCompositeType.PAR, DMUnitType.PAR);
        ourComposite2UnitType.put(DMCompositeType.PLAN, DMUnitType.PLAN);
        ourInstance = new DMUnitDescriptorProvider();
    }
}

