/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.facet;

import com.intellij.dmserver.facet.DMBundleFacet;
import com.intellij.dmserver.facet.DMBundleSupportProvider;
import com.intellij.dmserver.facet.DMCompositeFacet;
import com.intellij.dmserver.facet.DMCompositeSupportProvider;
import com.intellij.dmserver.facet.DMConfigFacet;
import com.intellij.dmserver.facet.DMConfigSupportProvider;
import com.intellij.dmserver.facet.DMServerSupportConfigurable;
import com.intellij.dmserver.util.DmServerBundle;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetTypeId;
import com.intellij.ide.util.frameworkSupport.FrameworkRole;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportConfigurable;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportProvider;
import com.intellij.javaee.framework.JavaeeProjectCategory;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import icons.DmServerSupportIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DMServerSupportProvider
extends FrameworkSupportProvider {
    @NonNls
    private static final String ID = "framework:dmServer";
    private static final String TITLE = DmServerBundle.message("DMServerSupportProvider.title", new Object[0]);
    private static final FacetTypeId<?>[] PROVIDED_FACET_IDS = new FacetTypeId[]{DMBundleFacet.ID, DMCompositeFacet.ID, DMConfigFacet.ID};
    private final DMBundleSupportProvider myBundleSupportProvider = new DMBundleSupportProvider();
    private final DMConfigSupportProvider myConfigSupportProvider;
    private final DMCompositeSupportProvider myCompositeSupportProvider = new DMCompositeSupportProvider();

    public DMServerSupportProvider() {
        super(ID, TITLE);
        this.myConfigSupportProvider = new DMConfigSupportProvider();
    }

    public DMBundleSupportProvider getBundleSupportProvider() {
        return this.myBundleSupportProvider;
    }

    public DMCompositeSupportProvider getCompositeSupportProvider() {
        return this.myCompositeSupportProvider;
    }

    public DMConfigSupportProvider getConfigSupportProvider() {
        return this.myConfigSupportProvider;
    }

    @NotNull
    public FrameworkSupportConfigurable createConfigurable(@NotNull FrameworkSupportModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/dmserver/facet/DMServerSupportProvider", "createConfigurable"));
        }
        DMServerSupportConfigurable dMServerSupportConfigurable = new DMServerSupportConfigurable(model, this);
        if (dMServerSupportConfigurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/facet/DMServerSupportProvider", "createConfigurable"));
        }
        return dMServerSupportConfigurable;
    }

    @Nullable
    public Icon getIcon() {
        return DmServerSupportIcons.DM;
    }

    public boolean isEnabledForModuleType(@NotNull ModuleType moduleType) {
        if (moduleType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleType", "com/intellij/dmserver/facet/DMServerSupportProvider", "isEnabledForModuleType"));
        }
        return moduleType instanceof JavaModuleType;
    }

    public boolean isSupportAlreadyAdded(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/dmserver/facet/DMServerSupportProvider", "isSupportAlreadyAdded"));
        }
        FacetManager facetManager = FacetManager.getInstance((Module)module);
        for (FacetTypeId<?> facetId : PROVIDED_FACET_IDS) {
            if (facetManager.getFacetsByType(facetId).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public FrameworkRole[] getRoles() {
        return new FrameworkRole[]{JavaeeProjectCategory.ROLE};
    }
}

