/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.facet;

import com.intellij.dmserver.artifacts.DMArtifactTypeBase;
import com.intellij.dmserver.artifacts.WithModuleArtifactUtil;
import com.intellij.dmserver.facet.DMFacetConfigurationBase;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetType;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFacetCommonPart;
import com.intellij.javaee.facet.JavaeeFacetEx;
import com.intellij.javaee.facet.JavaeeFacetListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.util.descriptors.ConfigFileContainer;
import com.intellij.util.descriptors.ConfigFileInfoSet;
import com.intellij.util.descriptors.ConfigFileMetaDataProvider;
import com.intellij.util.descriptors.impl.ConfigFileInfoSetImpl;
import com.intellij.util.descriptors.impl.ConfigFileMetaDataRegistryImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DMFacetBase<C extends DMFacetConfigurationBase<C>>
extends JavaeeFacet
implements JavaeeFacetEx {
    private final JavaeeFacetCommonPart myCommonPart;

    public DMFacetBase(@NotNull FacetType dmFacetType, @NotNull Module module, @NotNull String name, @NotNull C configuration, @Nullable Facet underlyingFacet) {
        if (dmFacetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dmFacetType", "com/intellij/dmserver/facet/DMFacetBase", "<init>"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/dmserver/facet/DMFacetBase", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/dmserver/facet/DMFacetBase", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/dmserver/facet/DMFacetBase", "<init>"));
        }
        super(dmFacetType, module, name, configuration, underlyingFacet);
        ConfigFileMetaDataRegistryImpl metaDataProvider = new ConfigFileMetaDataRegistryImpl();
        ConfigFileInfoSetImpl descriptorsConfig = new ConfigFileInfoSetImpl((ConfigFileMetaDataProvider)metaDataProvider);
        this.myCommonPart = new JavaeeFacetCommonPart((JavaeeFacet)this, (ConfigFileMetaDataProvider)metaDataProvider, (ConfigFileInfoSet)descriptorsConfig);
        Disposer.register((Disposable)this, (Disposable)this.myCommonPart);
    }

    public JavaeeFacetCommonPart getCommonPart() {
        return this.myCommonPart;
    }

    public ConfigFileContainer getDescriptorsContainer() {
        return this.myCommonPart.getDescriptorsContainer();
    }

    public ModificationTracker getModificationTracker() {
        return this.myCommonPart.getModificationTracker();
    }

    public void addFacetListener(JavaeeFacetListener listener) {
        this.myCommonPart.addListener(listener);
    }

    public void removeFacetListener(JavaeeFacetListener listener) {
        this.myCommonPart.removeListener(listener);
    }

    public void onFacetChanged() {
        this.updateMainArtifact();
    }

    public void updateSupportWithArtifact(ModifiableRootModel rootModel, ModulesProvider modulesProvider) {
        this.updateSupport(rootModel, modulesProvider);
        this.updateMainArtifact();
    }

    public void updateMainArtifact() {
        new WriteAction(){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/dmserver/facet/DMFacetBase$1", "run"));
                }
                DMArtifactTypeBase artifactType = DMFacetBase.this.selectMainArtifactType();
                Artifact mainArtifact = DMFacetBase.this.getMainArtifact();
                if (mainArtifact != null && artifactType.isCompatibleArtifact(mainArtifact)) {
                    artifactType.synchronizeArtifact(mainArtifact, DMFacetBase.this.getModule(), DMFacetBase.this);
                    return;
                }
                if (mainArtifact != null) {
                    ArtifactManager manager = ArtifactManager.getInstance((Project)DMFacetBase.this.getModule().getProject());
                    ModifiableArtifactModel model = manager.createModifiableModel();
                    model.removeArtifact(mainArtifact);
                    model.commit();
                }
                artifactType.createArtifactFor(DMFacetBase.this.getModule(), DMFacetBase.this);
            }
        }.execute();
    }

    public Artifact getMainArtifact() {
        return WithModuleArtifactUtil.findDmBundleArtifactFor(this.getModule());
    }

    public abstract DMArtifactTypeBase selectMainArtifactType();

    public abstract C getConfigurationImpl();

    protected abstract void updateSupport(ModifiableRootModel var1, ModulesProvider var2);
}

