/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.facet;

import com.intellij.dmserver.artifacts.ConfigFileManager;
import com.intellij.dmserver.artifacts.DMConfigArtifactType;
import com.intellij.dmserver.facet.DMConfigFacetConfiguration;
import com.intellij.dmserver.facet.DMConfigFacetType;
import com.intellij.dmserver.facet.DMFacetBase;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetTypeId;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ArtifactType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DMConfigFacet
extends DMFacetBase<DMConfigFacetConfiguration> {
    public static final FacetTypeId<DMConfigFacet> ID = new FacetTypeId("dmServerConfig");
    private static final Collection<ArtifactType> ourSupportedArtifacts;
    private final ConfigFileManager myConfigFileManager;

    public static Collection<ArtifactType> getSupportedArtifactTypes() {
        return ourSupportedArtifacts;
    }

    public DMConfigFacet(@NotNull DMConfigFacetType facetType, @NotNull Module module, @NotNull String name, @NotNull DMConfigFacetConfiguration configuration, @Nullable Facet underlyingFacet) {
        if (facetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetType", "com/intellij/dmserver/facet/DMConfigFacet", "<init>"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/dmserver/facet/DMConfigFacet", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/dmserver/facet/DMConfigFacet", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/dmserver/facet/DMConfigFacet", "<init>"));
        }
        super(facetType, module, name, configuration, underlyingFacet);
        this.myConfigFileManager = new ConfigFileManager(module);
    }

    @Nullable
    public static DMConfigFacet getInstance(Module module) {
        return (DMConfigFacet)FacetManager.getInstance((Module)module).getFacetByType(ID);
    }

    @Override
    public DMConfigFacetConfiguration getConfigurationImpl() {
        return (DMConfigFacetConfiguration)this.getConfiguration();
    }

    @NotNull
    public Collection<VirtualFile> getFacetRoots() {
        List<VirtualFile> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/facet/DMConfigFacet", "getFacetRoots"));
        }
        return list;
    }

    @Override
    @NotNull
    public DMConfigArtifactType selectMainArtifactType() {
        DMConfigArtifactType dMConfigArtifactType = DMConfigArtifactType.getInstance();
        if (dMConfigArtifactType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/facet/DMConfigFacet", "selectMainArtifactType"));
        }
        return dMConfigArtifactType;
    }

    public ConfigFileManager getConfigFileManager() {
        return this.myConfigFileManager;
    }

    @Override
    public void updateSupport(ModifiableRootModel rootModel, ModulesProvider modulesProvider) {
        this.getConfigFileManager().createConfigFile((ModuleRootModel)rootModel);
    }

    static {
        ArrayList<DMConfigArtifactType> supportedArtifacts = new ArrayList<DMConfigArtifactType>();
        supportedArtifacts.add(DMConfigArtifactType.getInstance());
        ourSupportedArtifacts = Collections.unmodifiableCollection(supportedArtifacts);
    }
}

