/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.facet;

import com.intellij.dmserver.artifacts.DMBundleArtifactType;
import com.intellij.dmserver.artifacts.ManifestManager;
import com.intellij.dmserver.facet.DMBundleFacetConfiguration;
import com.intellij.dmserver.facet.DMBundleFacetType;
import com.intellij.dmserver.facet.DMFacetBase;
import com.intellij.dmserver.facet.DMServerSupportProvider;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetModel;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportProvider;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.javaee.web.facet.WebFacetType;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.psi.PsiElement;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.osgi.jps.model.ManifestGenerationMode;
import org.osmorc.facet.OsmorcFacet;
import org.osmorc.facet.OsmorcFacetConfiguration;

public class DMBundleFacet
extends DMFacetBase<DMBundleFacetConfiguration> {
    private static final Logger LOG = Logger.getInstance((String)("#" + DMBundleFacet.class.getName()));
    @NonNls
    private static final String SPRING_DIR = "spring";
    @NonNls
    public static final String SPRING_PATH = "META-INF/spring";
    public static final FacetTypeId<DMBundleFacet> ID = new FacetTypeId("dmServerBundle");
    private static final Collection<ArtifactType> ourSupportedArtifacts;

    public static Collection<ArtifactType> getSupportedArtifactTypes() {
        return ourSupportedArtifacts;
    }

    public DMBundleFacet(@NotNull DMBundleFacetType facetType, @NotNull Module module, @NotNull String name, @NotNull DMBundleFacetConfiguration configuration, @Nullable Facet underlyingFacet) {
        if (facetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetType", "com/intellij/dmserver/facet/DMBundleFacet", "<init>"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/dmserver/facet/DMBundleFacet", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/dmserver/facet/DMBundleFacet", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/dmserver/facet/DMBundleFacet", "<init>"));
        }
        super(facetType, module, name, configuration, underlyingFacet);
    }

    @Nullable
    public static DMBundleFacet getInstance(Module module) {
        return (DMBundleFacet)FacetManager.getInstance((Module)module).getFacetByType(ID);
    }

    public static boolean hasDmFacet(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/dmserver/facet/DMBundleFacet", "hasDmFacet"));
        }
        return DMBundleFacet.getInstance(element) != null;
    }

    @Nullable
    public static DMBundleFacet getInstance(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/dmserver/facet/DMBundleFacet", "getInstance"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module != null) {
            return DMBundleFacet.getInstance(module);
        }
        return null;
    }

    @Override
    public DMBundleFacetConfiguration getConfigurationImpl() {
        return (DMBundleFacetConfiguration)this.getConfiguration();
    }

    @NotNull
    public Collection<VirtualFile> getFacetRoots() {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        VirtualFile manifestFolder = ManifestManager.getBundleInstance().findManifestFolder(this.getModule());
        if (manifestFolder != null) {
            result.add(manifestFolder);
        }
        ArrayList<VirtualFile> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/facet/DMBundleFacet", "getFacetRoots"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public DMBundleArtifactType selectMainArtifactType() {
        DMBundleArtifactType dMBundleArtifactType = DMBundleArtifactType.getInstance();
        if (dMBundleArtifactType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/facet/DMBundleFacet", "selectMainArtifactType"));
        }
        return dMBundleArtifactType;
    }

    @Override
    public void updateSupport(final ModifiableRootModel rootModel, final ModulesProvider modulesProvider) {
        RunResult result = new WriteAction<VirtualFile>(){

            protected void run(@NotNull Result<VirtualFile> result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/dmserver/facet/DMBundleFacet$1", "run"));
                }
                DMBundleFacet.this.doUpdateSupport(rootModel, modulesProvider);
            }
        }.executeSilently();
        result.logException(LOG);
    }

    private void doUpdateSupport(ModifiableRootModel rootModel, ModulesProvider modulesProvider) throws IOException {
        VirtualFile metaInfDir;
        Module module = this.getModule();
        DMBundleFacetConfiguration facetConfiguration = this.getConfigurationImpl();
        OsmorcFacet osmorcFacet = (OsmorcFacet)this.getUnderlyingFacet();
        ((OsmorcFacetConfiguration)osmorcFacet.getConfiguration()).setManifestGenerationMode(ManifestGenerationMode.Manually);
        VirtualFile manifest = ManifestManager.getBundleInstance().createManifest(module, osmorcFacet, (ModuleRootModel)rootModel, null, null);
        JarContentUtil<VirtualFile> springJarContentUtil = new JarContentUtil<VirtualFile>(osmorcFacet){

            @Override
            protected Pair<String, String> createJarContentsItem(VirtualFile metaInfDir) {
                return 2.doCreateJarContentsItem(metaInfDir.getPath() + "/" + DMBundleFacet.SPRING_DIR, DMBundleFacet.SPRING_PATH);
            }
        };
        if (facetConfiguration.getIsSpringDM()) {
            DMBundleFacet.addRequiredFacet(module, SpringFacet.getSpringFacetType(), modulesProvider);
            if (manifest != null) {
                metaInfDir = manifest.getParent();
                VirtualFile springDir = this.findOrCreateChildDirectory(metaInfDir, SPRING_DIR);
                this.createFileFromTemplate("module-context.xml", springDir, "module-context.xml");
                this.createFileFromTemplate("osgi-context.xml", springDir, "osgi-context.xml");
                springJarContentUtil.addItem(metaInfDir);
            }
        } else {
            DMBundleFacet.removeRequiredFacet(module, SpringFacet.getSpringFacetType(), modulesProvider);
            if (manifest != null) {
                metaInfDir = manifest.getParent();
                springJarContentUtil.removeItem(metaInfDir);
            }
        }
        if (facetConfiguration.getIsWebModule()) {
            WebFacet newWebFacet = (WebFacet)DMBundleFacet.addRequiredFacet(module, WebFacetType.getInstance(), modulesProvider);
            if (newWebFacet != null) {
                DMServerSupportProvider supportProvider = (DMServerSupportProvider)((Object)FrameworkSupportProvider.EXTENSION_POINT.findExtension(DMServerSupportProvider.class));
                supportProvider.getBundleSupportProvider().getWebSupportProvider().addSupport(newWebFacet, rootModel, facetConfiguration.getWebFrameworkVersionName());
            }
        } else {
            DMBundleFacet.removeRequiredFacet(module, WebFacetType.getInstance(), modulesProvider);
        }
    }

    private VirtualFile findOrCreateChildDirectory(VirtualFile parent, String name) throws IOException {
        VirtualFile child = parent.findChild(name);
        if (child != null) {
            return child;
        }
        return parent.createChildDirectory((Object)this, name);
    }

    @Nullable
    private VirtualFile createFileFromTemplate(String templateName, VirtualFile parent, @NonNls String fileName) {
        FileTemplate template = FileTemplateManager.getDefaultInstance().getJ2eeTemplate(templateName);
        try {
            String text = template.getText(FileTemplateManager.getDefaultInstance().getDefaultProperties());
            VirtualFile file = parent.findChild(fileName);
            if (file == null) {
                file = parent.createChildData((Object)this, fileName);
                VfsUtil.saveText((VirtualFile)file, (String)text);
            }
            return file;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    public static <F extends Facet, C extends FacetConfiguration> F addRequiredFacet(Module module, @NotNull FacetType<F, C> facetType, @Nullable ModulesProvider modulesProvider) {
        if (facetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetType", "com/intellij/dmserver/facet/DMBundleFacet", "addRequiredFacet"));
        }
        final Ref result = new Ref(null);
        new RequiredFacetProcessor<F, C>(){

            @Override
            protected void doProcessFacetsList(List<F> facets, FacetManager manager, FacetModel model, FacetType<F, C> type) {
                if (!facets.isEmpty()) {
                    return;
                }
                Facet newFacet = manager.createFacet(type, type.getDefaultFacetName(), null);
                facets.add(newFacet);
                result.set((Object)newFacet);
                super.doProcessFacetsList(facets, manager, model, type);
            }

            @Override
            protected void doProcessFacet(ModifiableFacetModel modifiableModel, F facet) {
                modifiableModel.addFacet(facet);
            }
        }.process(module, facetType, modulesProvider);
        return (F)((Facet)result.get());
    }

    private static <F extends Facet, C extends FacetConfiguration> void removeRequiredFacet(Module module, @NotNull FacetType<F, C> facetType, @NotNull ModulesProvider modulesProvider) {
        if (facetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetType", "com/intellij/dmserver/facet/DMBundleFacet", "removeRequiredFacet"));
        }
        if (modulesProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulesProvider", "com/intellij/dmserver/facet/DMBundleFacet", "removeRequiredFacet"));
        }
        new RequiredFacetProcessor<F, C>(){

            @Override
            protected void doProcessFacet(ModifiableFacetModel modifiableModel, F facet) {
                modifiableModel.removeFacet(facet);
            }
        }.process(module, facetType, modulesProvider);
    }

    static {
        ArrayList<DMBundleArtifactType> supportedArtifacts = new ArrayList<DMBundleArtifactType>();
        supportedArtifacts.add(DMBundleArtifactType.getInstance());
        ourSupportedArtifacts = Collections.unmodifiableCollection(supportedArtifacts);
    }

    private static abstract class JarContentUtil<T> {
        private final OsmorcFacetConfiguration myConfiguration;

        public JarContentUtil(OsmorcFacet osmorcFacet) {
            this.myConfiguration = (OsmorcFacetConfiguration)osmorcFacet.getConfiguration();
        }

        public void addItem(T item) {
            Pair<String, String> contentsItem = this.createJarContentsItem(item);
            List contents = this.myConfiguration.getAdditionalJARContents();
            if (!contents.contains(contentsItem)) {
                ArrayList newContents = ContainerUtil.newArrayList((Iterable)contents);
                newContents.add(contentsItem);
                this.myConfiguration.setAdditionalJARContents((List)newContents);
            }
        }

        public void removeItem(T item) {
            Pair<String, String> contentsItem = this.createJarContentsItem(item);
            List contents = this.myConfiguration.getAdditionalJARContents();
            if (contents.contains(contentsItem)) {
                ArrayList newContents = ContainerUtil.newArrayList((Iterable)contents);
                newContents.remove(contentsItem);
                this.myConfiguration.setAdditionalJARContents((List)newContents);
            }
        }

        protected static Pair<String, String> doCreateJarContentsItem(String sourcePath, String destinationPath) {
            return Pair.create((Object)FileUtil.toSystemIndependentName((String)sourcePath), (Object)FileUtil.toSystemIndependentName((String)destinationPath));
        }

        protected abstract Pair<String, String> createJarContentsItem(T var1);
    }

    private static abstract class RequiredFacetProcessor<F extends Facet, C extends FacetConfiguration> {
        private RequiredFacetProcessor() {
        }

        public List<F> process(@NotNull Module module, @NotNull FacetType<F, C> type, @Nullable ModulesProvider modulesProvider) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/dmserver/facet/DMBundleFacet$RequiredFacetProcessor", "process"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/dmserver/facet/DMBundleFacet$RequiredFacetProcessor", "process"));
            }
            FacetManager manager = FacetManager.getInstance((Module)module);
            FacetManager model = modulesProvider == null ? manager : modulesProvider.getFacetModel(module);
            ArrayList facets = new ArrayList(model.getFacetsByType(type.getId()));
            this.doProcessFacetsList(facets, manager, (FacetModel)model, type);
            return facets;
        }

        protected void doProcessFacetsList(List<F> facets, FacetManager manager, FacetModel model, FacetType<F, C> type) {
            if (facets.isEmpty()) {
                return;
            }
            if (model instanceof ModifiableFacetModel) {
                for (Facet facet : facets) {
                    this.doProcessFacet((ModifiableFacetModel)model, facet);
                }
            } else {
                ModifiableFacetModel modifiableModel = manager.createModifiableModel();
                for (Facet facet : facets) {
                    this.doProcessFacet(modifiableModel, facet);
                }
                modifiableModel.commit();
            }
        }

        protected abstract void doProcessFacet(ModifiableFacetModel var1, F var2);
    }
}

