/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.editor.wrapper;

import com.intellij.dmserver.editor.wrapper.AttributeWrapper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.lang.manifest.psi.HeaderValuePart;
import org.osmorc.manifest.lang.psi.AssignmentExpression;
import org.osmorc.manifest.lang.psi.Attribute;
import org.osmorc.manifest.lang.psi.Clause;
import org.osmorc.manifest.lang.psi.Directive;

public class ClauseWrapper {
    private final String myName;
    private final Map<String, AttributeWrapper> myAttributes;
    private final Map<String, AttributeWrapper> myDirectives;

    @Nullable
    public static ClauseWrapper create(Clause clause) {
        HeaderValuePart valuePart = (HeaderValuePart)PsiTreeUtil.getChildOfType((PsiElement)clause, HeaderValuePart.class);
        return valuePart == null || "".equals(valuePart.getUnwrappedText()) ? null : new ClauseWrapper(clause, valuePart.getUnwrappedText());
    }

    private ClauseWrapper(Clause clause, String clauseName) {
        this.myName = clauseName;
        this.myAttributes = ClauseWrapper.initializeAssignments(clause, Attribute.class);
        this.myDirectives = ClauseWrapper.initializeAssignments(clause, Directive.class);
    }

    private static <T extends AssignmentExpression> Map<String, AttributeWrapper> initializeAssignments(Clause clause, Class<T> assignmentClass) {
        HashMap<String, AttributeWrapper> result = new HashMap<String, AttributeWrapper>();
        AssignmentExpression attribute = (AssignmentExpression)PsiTreeUtil.getChildOfType((PsiElement)clause, assignmentClass);
        while (attribute != null) {
            AttributeWrapper attributeWrapper = AttributeWrapper.create(attribute);
            if (attributeWrapper != null) {
                result.put(attributeWrapper.getName(), attributeWrapper);
            }
            attribute = (AssignmentExpression)PsiTreeUtil.getNextSiblingOfType((PsiElement)attribute, assignmentClass);
        }
        return result;
    }

    public String getName() {
        return this.myName;
    }

    @Nullable
    public String getAttributeValue(String attributeName) {
        return ClauseWrapper.getAssignmentValue(this.myAttributes, attributeName);
    }

    @Nullable
    public String getDirectiveValue(String directiveName) {
        return ClauseWrapper.getAssignmentValue(this.myDirectives, directiveName);
    }

    private static String getAssignmentValue(Map<String, AttributeWrapper> assignments, String assignmentName) {
        AttributeWrapper assignment = assignments.get(assignmentName);
        return assignment == null ? null : assignment.getValue();
    }
}

