/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.editor;

import com.intellij.dmserver.editor.ManifestFileEditor;
import com.intellij.dmserver.facet.DMBundleFacet;
import com.intellij.facet.FacetFinder;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.lang.manifest.ManifestFileType;

public class ManifestFileEditorProvider
implements FileEditorProvider,
DumbAware {
    @NonNls
    private static final String TYPE_ID = "dm-manifest-editor";

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dmserver/editor/ManifestFileEditorProvider", "accept"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/dmserver/editor/ManifestFileEditorProvider", "accept"));
        }
        if (file.isDirectory() || !file.isValid()) {
            return false;
        }
        FileType fileType = file.getFileType();
        if (!(fileType instanceof ManifestFileType)) {
            return false;
        }
        return ManifestFileEditorProvider.findBundleFacet(project, file) != null;
    }

    private static DMBundleFacet findBundleFacet(Project project, VirtualFile file) {
        FacetFinder facetFinder = FacetFinder.getInstance((Project)project);
        return (DMBundleFacet)facetFinder.findFacet(file, DMBundleFacet.ID);
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dmserver/editor/ManifestFileEditorProvider", "createEditor"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/dmserver/editor/ManifestFileEditorProvider", "createEditor"));
        }
        ManifestFileEditor manifestFileEditor = new ManifestFileEditor(project, file);
        if (manifestFileEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/editor/ManifestFileEditorProvider", "createEditor"));
        }
        return manifestFileEditor;
    }

    @NotNull
    public String getEditorTypeId() {
        if (TYPE_ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/editor/ManifestFileEditorProvider", "getEditorTypeId"));
        }
        return TYPE_ID;
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        FileEditorPolicy fileEditorPolicy = FileEditorPolicy.PLACE_AFTER_DEFAULT_EDITOR;
        if (fileEditorPolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/editor/ManifestFileEditorProvider", "getPolicy"));
        }
        return fileEditorPolicy;
    }
}

