/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.editor;

import com.intellij.dmserver.artifacts.ManifestManager;
import com.intellij.dmserver.artifacts.ManifestManagerListener;
import com.intellij.dmserver.editor.ExportedUnit;
import com.intellij.dmserver.editor.ExportedUnitImpl;
import com.intellij.dmserver.editor.UnitsCollector;
import com.intellij.dmserver.editor.wrapper.ClauseWrapper;
import com.intellij.dmserver.editor.wrapper.HeaderWrapper;
import com.intellij.dmserver.facet.DMBundleFacet;
import com.intellij.dmserver.install.DMServerInstallation;
import com.intellij.dmserver.integration.RepositoryPattern;
import com.intellij.dmserver.libraries.BundleDefinition;
import com.intellij.dmserver.libraries.BundleWrapper;
import com.intellij.dmserver.libraries.LibraryDefinition;
import com.intellij.dmserver.osmorc.DMSourceBundleFinder;
import com.intellij.dmserver.osmorc.FrameworkUtils;
import com.intellij.dmserver.util.PsiTreeChangedAdapter;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetManagerAdapter;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osmorc.settings.ProjectSettings;

public class AvailableBundlesProvider
implements ProjectComponent {
    private static final Logger LOG = Logger.getInstance((String)("#" + AvailableBundlesProvider.class.getName()));
    @NonNls
    public static final String COMPONENT_NAME = "AvailableExportedUnitsProvider";
    @NonNls
    private static final String LIBRARY_EXTENSION = "libd";
    private final Project myProject;
    private final RepositoryIndex myRepositoryIndex;
    private final ProjectIndex myProjectIndex;
    private UnitsCollectorBase myPackagesCollector;
    private UnitsCollectorBase myBundlesCollector;
    private UnitsCollectorBase myLibrariesCollector;
    private PsiTreeChangeListener myPsiTreeChangeListener;
    private ManifestManagerListener myManifestManagerListener;
    private final DMSourceBundleFinder mySourceFinder = new DMSourceBundleFinder();

    public static AvailableBundlesProvider getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dmserver/editor/AvailableBundlesProvider", "getInstance"));
        }
        return (AvailableBundlesProvider)project.getComponent(AvailableBundlesProvider.class);
    }

    public AvailableBundlesProvider(Project project) {
        this.myProject = project;
        this.myRepositoryIndex = new RepositoryIndex();
        this.myProjectIndex = new ProjectIndex();
        this.myPackagesCollector = new UnitsCollectorBase(){

            @Override
            protected List<ExportedUnit> collectAvailableUnits() {
                ArrayList<ExportedUnit> result = new ArrayList<ExportedUnit>(AvailableBundlesProvider.this.myRepositoryIndex.getPackages());
                result.addAll(AvailableBundlesProvider.this.myProjectIndex.getPackages());
                return result;
            }
        };
        this.myBundlesCollector = new UnitsCollectorBase(){

            @Override
            protected List<ExportedUnit> collectAvailableUnits() {
                ArrayList<ExportedUnit> result = new ArrayList<ExportedUnit>(AvailableBundlesProvider.this.myRepositoryIndex.getBundles());
                result.addAll(AvailableBundlesProvider.this.myProjectIndex.getBundles());
                return result;
            }
        };
        this.myLibrariesCollector = new UnitsCollectorBase(){

            @Override
            protected List<ExportedUnit> collectAvailableUnits() {
                return AvailableBundlesProvider.this.myRepositoryIndex.getLibraries();
            }
        };
    }

    private List<BundleIndex> collectBundleIndexes() {
        ArrayList<BundleIndex> result = new ArrayList<BundleIndex>();
        for (Module module : ProjectFacetManager.getInstance((Project)this.myProject).getModulesWithFacet(DMBundleFacet.ID)) {
            ManifestManager.FileWrapper manifestWrapper = ManifestManager.getBundleInstance().findManifest(module);
            if (manifestWrapper == null) continue;
            result.add(new BundleIndex(module, manifestWrapper));
        }
        return result;
    }

    public void resetAll() {
        this.myRepositoryIndex.build();
        this.myProjectIndex.build();
        this.resetCollectors();
    }

    public void resetRepositoryIndex() {
        this.myRepositoryIndex.build();
        this.resetCollectors();
    }

    public void resetProjectIndex() {
        this.myProjectIndex.build();
        this.resetCollectors();
    }

    private void resetBundleIndex(BundleIndex bundleIndex) {
        this.myProjectIndex.buildBundle(bundleIndex);
        this.resetCollectors();
    }

    private void resetCollectors() {
        for (UnitsCollectorBase unitsCollectors : Arrays.asList(this.myPackagesCollector, this.myBundlesCollector, this.myLibrariesCollector)) {
            unitsCollectors.reset();
        }
    }

    public UnitsCollector getBundlesCollector() {
        return this.myBundlesCollector;
    }

    public UnitsCollector getLibrariesCollector() {
        return this.myLibrariesCollector;
    }

    public UnitsCollector getPackagesCollector() {
        return this.myPackagesCollector;
    }

    public List<LibraryDefinition> getRepositoryLibraries(RepositoryPattern repositoryPattern) {
        return this.myRepositoryIndex.getFolderLibraries(repositoryPattern);
    }

    public List<BundleWrapper> getRepositoryBundles(RepositoryPattern repositoryPattern) {
        return this.myRepositoryIndex.getFolderBundles(repositoryPattern);
    }

    public List<LibraryDefinition> getAllRepositoryLibraries() {
        return this.myRepositoryIndex.getAllLibraries();
    }

    public List<BundleWrapper> getAllRepositoryBundles() {
        return this.myRepositoryIndex.getAllBundles();
    }

    public static List<ExportedUnit> getExportedPackages(PsiFile manifestFile) {
        ArrayList<ExportedUnit> result = new ArrayList<ExportedUnit>();
        HeaderWrapper exportHeaderWrapper = new HeaderWrapper(manifestFile, "Export-Package");
        for (ClauseWrapper clause : exportHeaderWrapper.getClauses()) {
            result.add(new ExportedUnitImpl(clause.getName(), clause.getAttributeValue("version")));
        }
        return result;
    }

    public void projectOpened() {
        StartupManager.getInstance((Project)this.myProject).registerPostStartupActivity(() -> {
            this.resetAll();
            this.myPsiTreeChangeListener = new PsiTreeChangedAdapter(){

                @Override
                protected void treeChanged(PsiTreeChangeEvent event) {
                    PsiFile changedFile = event.getFile();
                    if (changedFile == null) {
                        return;
                    }
                    BundleIndex bundleIndex = this.findBundleIndex(changedFile);
                    if (bundleIndex == null) {
                        return;
                    }
                    AvailableBundlesProvider.this.resetBundleIndex(bundleIndex);
                }

                @Nullable
                private BundleIndex findBundleIndex(PsiFile changedFile) {
                    for (BundleIndex bundleIndex : AvailableBundlesProvider.this.collectBundleIndexes()) {
                        if (!Comparing.equal((Object)bundleIndex.getManifestWrapper().getFile().getVirtualFile(), (Object)changedFile.getVirtualFile())) continue;
                        return bundleIndex;
                    }
                    return null;
                }
            };
            PsiManager.getInstance((Project)this.myProject).addPsiTreeChangeListener(this.myPsiTreeChangeListener);
            ProjectSettings.getInstance((Project)this.myProject).addProjectSettingsListener(new ProjectSettings.ProjectSettingsListener(){

                public void projectSettingsChanged() {
                    AvailableBundlesProvider.this.resetRepositoryIndex();
                }
            });
            MessageBusConnection connection = this.myProject.getMessageBus().connect();
            connection.subscribe(FacetManager.FACETS_TOPIC, (Object)new FacetManagerAdapter(){

                public void facetRemoved(@NotNull Facet facet) {
                    if (facet == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/dmserver/editor/AvailableBundlesProvider$6", "facetRemoved"));
                    }
                    if (!(facet instanceof DMBundleFacet)) {
                        return;
                    }
                    AvailableBundlesProvider.this.myProjectIndex.removeBundle(facet.getModule());
                    AvailableBundlesProvider.this.resetCollectors();
                }
            });
            this.myManifestManagerListener = new ManifestManagerListener(){

                @Override
                public void manifestCreated(Module module, ManifestManager.FileWrapper manifest) {
                    if (module.getProject() != AvailableBundlesProvider.this.myProject) {
                        return;
                    }
                    AvailableBundlesProvider.this.resetBundleIndex(new BundleIndex(module, manifest));
                }
            };
            ManifestManager.getBundleInstance().addListener(this.myManifestManagerListener);
        });
    }

    public void projectClosed() {
        if (this.myPsiTreeChangeListener != null) {
            PsiManager.getInstance((Project)this.myProject).removePsiTreeChangeListener(this.myPsiTreeChangeListener);
        }
        if (this.myManifestManagerListener != null) {
            ManifestManager.getBundleInstance().removeListener(this.myManifestManagerListener);
        }
    }

    @NotNull
    public String getComponentName() {
        if (COMPONENT_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/editor/AvailableBundlesProvider", "getComponentName"));
        }
        return COMPONENT_NAME;
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    private static class BundleIndex {
        private Module myModule;
        private ManifestManager.FileWrapper myManifestWrapper;
        private ExportedUnit myBundle;
        private List<ExportedUnit> myPackages;

        public BundleIndex(Module module, ManifestManager.FileWrapper manifestWrapper) {
            this.myModule = module;
            this.myManifestWrapper = manifestWrapper;
        }

        public Module getModule() {
            return this.myModule;
        }

        public ManifestManager.FileWrapper getManifestWrapper() {
            return this.myManifestWrapper;
        }

        public void build() {
            this.myBundle = new ExportedUnitImpl(this.myManifestWrapper.getSymbolicName(), this.myManifestWrapper.getVersion());
            this.myPackages = AvailableBundlesProvider.getExportedPackages((PsiFile)this.myManifestWrapper.getFile());
        }

        public ExportedUnit getBundle() {
            return this.myBundle;
        }

        public List<ExportedUnit> getPackages() {
            return this.myPackages;
        }
    }

    private class ProjectIndex {
        private List<ExportedUnit> myBundles;
        private List<ExportedUnit> myPackages;
        private Map<Module, BundleIndex> myModule2BundleIndex;

        private ProjectIndex() {
        }

        public List<ExportedUnit> getBundles() {
            return this.myBundles;
        }

        public List<ExportedUnit> getPackages() {
            return this.myPackages;
        }

        public void build() {
            this.myModule2BundleIndex = new HashMap<Module, BundleIndex>();
            for (BundleIndex bundleIndex : AvailableBundlesProvider.this.collectBundleIndexes()) {
                this.doBuildBundle(bundleIndex);
            }
            this.reset();
        }

        private void reset() {
            this.myBundles = new ArrayList<ExportedUnit>();
            this.myPackages = new ArrayList<ExportedUnit>();
            for (BundleIndex bundleIndex : this.myModule2BundleIndex.values()) {
                this.myBundles.add(bundleIndex.getBundle());
                this.myPackages.addAll(bundleIndex.getPackages());
            }
        }

        public void buildBundle(BundleIndex bundleIndex) {
            this.doBuildBundle(bundleIndex);
            this.reset();
        }

        private void doBuildBundle(BundleIndex bundleIndex) {
            bundleIndex.build();
            this.myModule2BundleIndex.put(bundleIndex.getModule(), bundleIndex);
        }

        public void removeBundle(Module module) {
            this.myModule2BundleIndex.remove(module);
            this.reset();
        }
    }

    private class RepositoryIndex {
        private LibrariesCollector myLibrariesCollector;
        private BundlesCollector myBundlesCollector;
        private List<ExportedUnit> myLibraries;
        private List<ExportedUnit> myBundles;
        private List<ExportedUnit> myPackages;

        private RepositoryIndex() {
        }

        public void build() {
            this.myLibrariesCollector = new LibrariesCollector();
            this.myLibrariesCollector.collect();
            this.myBundlesCollector = new BundlesCollector();
            this.myBundlesCollector.collect();
            this.myLibraries = this.collectLibraries(this.myLibrariesCollector.getAllUnits());
            List<BundleWrapper> bundleWrappers = this.myBundlesCollector.getAllUnits();
            this.myBundles = this.collectBundles(bundleWrappers);
            this.myPackages = this.collectPackages(bundleWrappers);
        }

        public List<ExportedUnit> getLibraries() {
            return this.myLibraries;
        }

        public List<ExportedUnit> getBundles() {
            return this.myBundles;
        }

        public List<ExportedUnit> getPackages() {
            return this.myPackages;
        }

        public List<LibraryDefinition> getFolderLibraries(RepositoryPattern repositoryPattern) {
            return this.myLibrariesCollector.getFolderUnits(repositoryPattern);
        }

        public List<BundleWrapper> getFolderBundles(RepositoryPattern repositoryPattern) {
            return this.myBundlesCollector.getFolderUnits(repositoryPattern);
        }

        public List<LibraryDefinition> getAllLibraries() {
            return this.myLibrariesCollector.getAllUnits();
        }

        public List<BundleWrapper> getAllBundles() {
            return this.myBundlesCollector.getAllUnits();
        }

        private List<ExportedUnit> collectPackages(List<BundleWrapper> bundleWrappers) {
            ArrayList<ExportedUnit> result = new ArrayList<ExportedUnit>();
            for (BundleWrapper bundleWrapper : bundleWrappers) {
                PsiFile manifestFile = PsiManager.getInstance((Project)AvailableBundlesProvider.this.myProject).findFile(bundleWrapper.getManifestFile());
                if (manifestFile == null) {
                    LOG.error("Manifest PSI file is expected to exist");
                    continue;
                }
                result.addAll(AvailableBundlesProvider.getExportedPackages(manifestFile));
            }
            return result;
        }

        private List<ExportedUnit> collectLibraries(List<LibraryDefinition> libraryDefinitions) {
            ArrayList<ExportedUnit> result = new ArrayList<ExportedUnit>();
            for (LibraryDefinition libraryDefinition : libraryDefinitions) {
                result.add(new ExportedUnitImpl(libraryDefinition.getSymbolicName(), libraryDefinition.getVersion()));
            }
            return result;
        }

        private List<ExportedUnit> collectBundles(List<BundleWrapper> bundleWrappers) {
            ArrayList<ExportedUnit> result = new ArrayList<ExportedUnit>();
            for (BundleDefinition bundleDefinition : bundleWrappers) {
                result.add(new ExportedUnitImpl(bundleDefinition.getSymbolicName(), bundleDefinition.getVersion()));
            }
            return result;
        }

        @Nullable
        private DMServerInstallation getInstallation() {
            return FrameworkUtils.getInstance().getActiveDMServerInstallation(AvailableBundlesProvider.this.myProject);
        }

        private class BundlesCollector
        extends RepositoryUnitsCollector<BundleWrapper> {
            private BundlesCollector() {
            }

            @Override
            protected List<BundleWrapper> collectUnits(List<VirtualFile> files) {
                ArrayList<BundleWrapper> result = new ArrayList<BundleWrapper>();
                for (VirtualFile file : files) {
                    BundleWrapper bundle = BundleWrapper.load(file);
                    if (bundle == null || AvailableBundlesProvider.this.mySourceFinder.containsOnlySources(file)) continue;
                    result.add(bundle);
                }
                return result;
            }
        }

        private class LibrariesCollector
        extends RepositoryUnitsCollector<LibraryDefinition> {
            private LibrariesCollector() {
            }

            @Override
            protected List<LibraryDefinition> collectUnits(List<VirtualFile> files) {
                ArrayList<LibraryDefinition> result = new ArrayList<LibraryDefinition>();
                for (VirtualFile file : files) {
                    LibraryDefinition libraryDefinition;
                    if (!AvailableBundlesProvider.LIBRARY_EXTENSION.equalsIgnoreCase(file.getExtension()) || (libraryDefinition = LibraryDefinition.load(AvailableBundlesProvider.this.myProject, file)) == null) continue;
                    result.add(libraryDefinition);
                }
                return result;
            }
        }

        private abstract class RepositoryUnitsCollector<U> {
            private Map<String, List<U>> myFolder2Units;
            private List<U> myAllUnits;

            private RepositoryUnitsCollector() {
            }

            public void collect() {
                DMServerInstallation installation = RepositoryIndex.this.getInstallation();
                if (installation == null) {
                    this.myFolder2Units = Collections.emptyMap();
                    this.myAllUnits = Collections.emptyList();
                    return;
                }
                this.myFolder2Units = new HashMap<String, List<U>>();
                this.myAllUnits = new ArrayList<U>();
                for (RepositoryPattern repositoryPattern : installation.collectRepositoryPatterns()) {
                    List<U> folderUnits = this.collectUnits(repositoryPattern.collectFiles());
                    this.myFolder2Units.put(repositoryPattern.getFullPattern(), folderUnits);
                    this.myAllUnits.addAll(folderUnits);
                }
            }

            public List<U> getAllUnits() {
                return this.myAllUnits;
            }

            public List<U> getFolderUnits(RepositoryPattern repositoryPattern) {
                List<U> folderUnits = this.myFolder2Units.get(repositoryPattern.getFullPattern());
                return new ArrayList(folderUnits == null ? Collections.emptyList() : folderUnits);
            }

            protected abstract List<U> collectUnits(List<VirtualFile> var1);
        }
    }

    private static abstract class UnitsCollectorBase
    implements UnitsCollector {
        private List<ExportedUnit> myAvailableUnits;
        private Set<String> myAvailableUnitNames;

        private UnitsCollectorBase() {
        }

        public void reset() {
            this.myAvailableUnits = this.collectAvailableUnits();
            this.myAvailableUnitNames = new HashSet<String>();
            for (ExportedUnit availableUnit : this.myAvailableUnits) {
                this.myAvailableUnitNames.add(availableUnit.getSymbolicName());
            }
        }

        @Override
        public List<ExportedUnit> getAvailableUnits() {
            return this.myAvailableUnits;
        }

        @Override
        public boolean isUnitAvailable(String symbolicName) {
            return this.myAvailableUnitNames.contains(symbolicName);
        }

        protected abstract List<ExportedUnit> collectAvailableUnits();
    }
}

