/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.deploy.jmx;

import com.intellij.dmserver.DMConstants;
import com.intellij.dmserver.deploy.jmx.AbstractDMConnectorCommand;
import com.intellij.dmserver.deploy.jmx.ConnectorFileDeployCommand;
import com.intellij.dmserver.run.DMServerInstance;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.springsource.server.management.remote.BundleAdmin;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBundleAdminCommand<T>
extends AbstractDMConnectorCommand<T> {
    private static boolean ourUnrecoverableError = false;

    public AbstractBundleAdminCommand(DMServerInstance dmServer) {
        super(dmServer);
    }

    protected void checkBundleAdminAndInstall(MBeanServerConnection connection) throws IOException {
        if (ourUnrecoverableError) {
            throw new IOException("We were unable to install connector bundle before. This is unrecoverable condition");
        }
        try {
            connection.getObjectInstance(DMConstants.MBEAN_BUNDLE_ADMIN);
        }
        catch (InstanceNotFoundException e) {
            VirtualFile connectorBundle = AbstractBundleAdminCommand.getConnectorBundle();
            if (connectorBundle == null) {
                ourUnrecoverableError = true;
                throw new IOException("Can't find connector bundle");
            }
            try {
                new ConnectorFileDeployCommand(this.getServerInstance(), connectorBundle).execute();
            }
            catch (TimeoutException ex) {
                throw new IOException(ex);
            }
            catch (ExecutionException ex) {
                throw new IOException(ex);
            }
        }
    }

    @Nullable
    private static VirtualFile getConnectorBundle() {
        return LocalFileSystem.getInstance().findFileByPath(PathUtil.getJarPathForClass(BundleAdmin.class));
    }
}

