/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.deploy;

import com.intellij.dmserver.artifacts.DMArtifactTypeBase;
import com.intellij.dmserver.artifacts.DMPlanArtifactType;
import com.intellij.dmserver.deploy.CommandsCollector;
import com.intellij.dmserver.deploy.IDMCommand;
import com.intellij.dmserver.deploy.RepositoryUndeployCommand;
import com.intellij.dmserver.deploy.jmx.ConnectorUndeployCommand;
import com.intellij.dmserver.run.DMServerInstance;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.ui.packaging.WarArtifactType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class UndeployCommandsCollector
extends CommandsCollector {
    public UndeployCommandsCollector(@NotNull DMServerInstance serverInstance, @NotNull DeploymentModel model) {
        if (serverInstance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverInstance", "com/intellij/dmserver/deploy/UndeployCommandsCollector", "<init>"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/dmserver/deploy/UndeployCommandsCollector", "<init>"));
        }
        super(serverInstance, model);
    }

    @Override
    protected void collectCommandsForDmArtifact(@NotNull Artifact artifact, @NotNull DMArtifactTypeBase type, @NotNull List<IDMCommand> result) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/dmserver/deploy/UndeployCommandsCollector", "collectCommandsForDmArtifact"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/dmserver/deploy/UndeployCommandsCollector", "collectCommandsForDmArtifact"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/dmserver/deploy/UndeployCommandsCollector", "collectCommandsForDmArtifact"));
        }
        result.add(this.createUndeployCommand());
        if (type instanceof DMPlanArtifactType) {
            List<VirtualFile> secondaryFilesToUndeploy = ((DMPlanArtifactType)type).findSecondaryFilesToDeploy(artifact);
            result.add(new RepositoryUndeployCommand(this.getServerInstance(), secondaryFilesToUndeploy));
        }
    }

    @Override
    protected void collectCommandsForWarArtifact(@NotNull Artifact artifact, @NotNull WarArtifactType type, @NotNull List<IDMCommand> result) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/dmserver/deploy/UndeployCommandsCollector", "collectCommandsForWarArtifact"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/dmserver/deploy/UndeployCommandsCollector", "collectCommandsForWarArtifact"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/dmserver/deploy/UndeployCommandsCollector", "collectCommandsForWarArtifact"));
        }
        result.add(this.createUndeployCommand());
    }

    private ConnectorUndeployCommand createUndeployCommand() {
        return new ConnectorUndeployCommand(this.getServerInstance(), this.getModel());
    }
}

