/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.deploy;

import com.intellij.dmserver.artifacts.DMArtifactTypeBase;
import com.intellij.dmserver.artifacts.DMPlanArtifactType;
import com.intellij.dmserver.deploy.CommandsCollector;
import com.intellij.dmserver.deploy.IDMCommand;
import com.intellij.dmserver.deploy.RepositoryDeployCommand;
import com.intellij.dmserver.deploy.jmx.ConnectorDeployCommand;
import com.intellij.dmserver.deploy.jmx.ConnectorForceCheckCommand;
import com.intellij.dmserver.run.DMServerInstance;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.ui.packaging.WarArtifactType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeployCommandsCollector
extends CommandsCollector {
    public DeployCommandsCollector(@NotNull DMServerInstance serverInstance, @NotNull DeploymentModel model) {
        if (serverInstance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverInstance", "com/intellij/dmserver/deploy/DeployCommandsCollector", "<init>"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/dmserver/deploy/DeployCommandsCollector", "<init>"));
        }
        super(serverInstance, model);
    }

    @Override
    protected void collectCommandsForDmArtifact(@NotNull Artifact artifact, @NotNull DMArtifactTypeBase type, @NotNull List<IDMCommand> result) throws IOException {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/dmserver/deploy/DeployCommandsCollector", "collectCommandsForDmArtifact"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/dmserver/deploy/DeployCommandsCollector", "collectCommandsForDmArtifact"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/dmserver/deploy/DeployCommandsCollector", "collectCommandsForDmArtifact"));
        }
        if (type instanceof DMPlanArtifactType) {
            List<VirtualFile> secondaryFilesToDeploy = ((DMPlanArtifactType)type).findSecondaryFilesToDeploy(artifact);
            result.add(new RepositoryDeployCommand(this.getServerInstance(), secondaryFilesToDeploy));
            result.add(new ConnectorForceCheckCommand(this.getServerInstance()));
        }
        VirtualFile mainFileToDeploy = type.findMainFileToDeploy(artifact);
        result.add(this.createConnectorDeployCommand(mainFileToDeploy));
    }

    @Override
    protected void collectCommandsForWarArtifact(@NotNull Artifact artifact, @NotNull WarArtifactType type, @NotNull List<IDMCommand> result) throws IOException {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/dmserver/deploy/DeployCommandsCollector", "collectCommandsForWarArtifact"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/dmserver/deploy/DeployCommandsCollector", "collectCommandsForWarArtifact"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/dmserver/deploy/DeployCommandsCollector", "collectCommandsForWarArtifact"));
        }
        VirtualFile mainFileToDeploy = DMArtifactTypeBase.findFileByExtension(artifact, "war");
        result.add(this.createConnectorDeployCommand(mainFileToDeploy));
    }

    private ConnectorDeployCommand createConnectorDeployCommand(@Nullable VirtualFile mainFileToDeploy) throws IOException {
        if (mainFileToDeploy == null) {
            throw new IOException("Can't find main file to deploy");
        }
        return new ConnectorDeployCommand(this.getServerInstance(), this.getModel(), mainFileToDeploy);
    }
}

