/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.artifacts;

import com.intellij.dmserver.util.ManifestUtils;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.lang.manifest.psi.Header;
import org.jetbrains.lang.manifest.psi.ManifestFile;

public class ManifestUpdater {
    private final ManifestFile myManifestFile;

    public ManifestUpdater(@NotNull ManifestFile manifestFile) {
        if (manifestFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manifestFile", "com/intellij/dmserver/artifacts/ManifestUpdater", "<init>"));
        }
        this.myManifestFile = manifestFile;
    }

    public void updateHeader(@NotNull String headerName, @NotNull String headerValue, boolean keepExistingValue) {
        if (headerName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headerName", "com/intellij/dmserver/artifacts/ManifestUpdater", "updateHeader"));
        }
        if (headerValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headerValue", "com/intellij/dmserver/artifacts/ManifestUpdater", "updateHeader"));
        }
        WriteCommandAction.runWriteCommandAction((Project)this.myManifestFile.getProject(), () -> {
            if (headerName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headerName", "com/intellij/dmserver/artifacts/ManifestUpdater", "lambda$updateHeader$0"));
            }
            if (headerValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headerValue", "com/intellij/dmserver/artifacts/ManifestUpdater", "lambda$updateHeader$0"));
            }
            Header header = ManifestUtils.getInstance().findHeader((PsiFile)this.myManifestFile, headerName);
            if (keepExistingValue && header != null && ManifestUtils.getInstance().getHeaderValue(header) != null) {
                return;
            }
            Header newHeader = ManifestUtils.getInstance().createHeader(this.myManifestFile.getProject(), headerName, headerValue);
            if (header == null) {
                ManifestUtils.getInstance().addHeader((PsiFile)this.myManifestFile, newHeader);
            } else {
                header.replace((PsiElement)newHeader);
            }
        });
    }
}

