/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.artifacts;

import com.intellij.dmserver.artifacts.DMBundleArtifactType;
import com.intellij.dmserver.artifacts.DMContainerPackagingElement;
import com.intellij.dmserver.artifacts.WithModulePackagingElementType;
import com.intellij.dmserver.util.DmServerBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.ui.ArtifactEditorContext;
import icons.DmServerSupportIcons;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.osmorc.facet.OsmorcFacet;

public class DMContainerPackagingElementType
extends WithModulePackagingElementType<DMContainerPackagingElement> {
    public static DMContainerPackagingElementType getInstance() {
        return (DMContainerPackagingElementType)DMContainerPackagingElementType.getInstance(DMContainerPackagingElementType.class);
    }

    public DMContainerPackagingElementType() {
        super("packaging-for-osgi-module", DmServerBundle.message("DMContainerPackagingElementType.presentable.name", new Object[0]));
    }

    public boolean canCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/dmserver/artifacts/DMContainerPackagingElementType", "canCreate"));
        }
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/dmserver/artifacts/DMContainerPackagingElementType", "canCreate"));
        }
        return artifact.getArtifactType() instanceof DMBundleArtifactType;
    }

    public Icon getCreateElementIcon() {
        return DmServerSupportIcons.Bundle;
    }

    @NotNull
    public DMContainerPackagingElement createEmpty(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dmserver/artifacts/DMContainerPackagingElementType", "createEmpty"));
        }
        DMContainerPackagingElement dMContainerPackagingElement = new DMContainerPackagingElement(this, project, null);
        if (dMContainerPackagingElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/artifacts/DMContainerPackagingElementType", "createEmpty"));
        }
        return dMContainerPackagingElement;
    }

    @NotNull
    public List<? extends PackagingElement<?>> chooseAndCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact, @NotNull CompositePackagingElement<?> parent) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/dmserver/artifacts/DMContainerPackagingElementType", "chooseAndCreate"));
        }
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/dmserver/artifacts/DMContainerPackagingElementType", "chooseAndCreate"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/dmserver/artifacts/DMContainerPackagingElementType", "chooseAndCreate"));
        }
        List<Module> modules = DMContainerPackagingElementType.chooseModules(context);
        ArrayList result = new ArrayList();
        for (Module next : modules) {
            if (!OsmorcFacet.hasOsmorcFacet((Module)next)) continue;
            result.add(this.createFor(next));
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/artifacts/DMContainerPackagingElementType", "chooseAndCreate"));
        }
        return arrayList;
    }

    public static List<Module> chooseModules(ArtifactEditorContext context) {
        ArrayList<Module> osmorcModules = new ArrayList<Module>();
        for (Module nextModule : context.getModulesProvider().getModules()) {
            if (!OsmorcFacet.hasOsmorcFacet((Module)nextModule)) continue;
            osmorcModules.add(nextModule);
        }
        return context.chooseModules(osmorcModules, DmServerBundle.message("DMContainerPackagingElementType.chooser.title", new Object[0]));
    }
}

