/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.artifacts;

import com.intellij.dmserver.artifacts.DMCompositeArtifactTypeBase;
import com.intellij.dmserver.artifacts.DMCompositePackagingElement;
import com.intellij.dmserver.artifacts.WithModulePackagingElementType;
import com.intellij.dmserver.util.DmServerBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.ui.ArtifactEditorContext;
import icons.DmServerSupportIcons;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DMCompositePackagingElementType
extends WithModulePackagingElementType<DMCompositePackagingElement> {
    @NonNls
    public static final String TYPE_ID = "packaging-for-dm-composite";

    public static DMCompositePackagingElementType getInstance() {
        return (DMCompositePackagingElementType)DMCompositePackagingElementType.getInstance(DMCompositePackagingElementType.class);
    }

    public DMCompositePackagingElementType() {
        super(TYPE_ID, DmServerBundle.message("DMCompositePackagingElementType.presentable.name", new Object[0]));
    }

    public boolean canCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/dmserver/artifacts/DMCompositePackagingElementType", "canCreate"));
        }
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/dmserver/artifacts/DMCompositePackagingElementType", "canCreate"));
        }
        return artifact.getArtifactType() instanceof DMCompositeArtifactTypeBase;
    }

    public Icon getCreateElementIcon() {
        return DmServerSupportIcons.DM;
    }

    @NotNull
    public DMCompositePackagingElement createEmpty(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dmserver/artifacts/DMCompositePackagingElementType", "createEmpty"));
        }
        DMCompositePackagingElement dMCompositePackagingElement = new DMCompositePackagingElement(this, project, null);
        if (dMCompositePackagingElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/artifacts/DMCompositePackagingElementType", "createEmpty"));
        }
        return dMCompositePackagingElement;
    }

    @NotNull
    public List<? extends PackagingElement<?>> chooseAndCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact, @NotNull CompositePackagingElement<?> parent) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/dmserver/artifacts/DMCompositePackagingElementType", "chooseAndCreate"));
        }
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/dmserver/artifacts/DMCompositePackagingElementType", "chooseAndCreate"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/dmserver/artifacts/DMCompositePackagingElementType", "chooseAndCreate"));
        }
        List<Module> modules = DMCompositePackagingElementType.chooseModules(context);
        ArrayList result = new ArrayList();
        for (Module next : modules) {
            result.add(this.createFor(next));
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/artifacts/DMCompositePackagingElementType", "chooseAndCreate"));
        }
        return arrayList;
    }

    public static List<Module> chooseModules(ArtifactEditorContext context) {
        return context.chooseModules(Arrays.asList(context.getModulesProvider().getModules()), DmServerBundle.message("DMCompositePackagingElementType.chooser.title", new Object[0]));
    }
}

