/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.artifacts;

import com.intellij.ProjectTopics;
import com.intellij.dmserver.artifacts.WithModuleArtifactUtil;
import com.intellij.dmserver.facet.DMFacetBase;
import com.intellij.dmserver.facet.DMFacetFinder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ModuleAdapter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ArtifactSynchronizer
extends ModuleAdapter
implements ModuleRootListener {
    private ModifiableArtifactModel myArtifactRemovingModel = null;

    public ArtifactSynchronizer(Project project, MessageBus messageBus) {
        MessageBusConnection connection = messageBus.connect((Disposable)project);
        connection.subscribe(ProjectTopics.MODULES, (Object)this);
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)this);
    }

    public void beforeModuleRemoved(@NotNull Project project, @NotNull Module module) {
        List<Artifact> artifactsForModule;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dmserver/artifacts/ArtifactSynchronizer", "beforeModuleRemoved"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/dmserver/artifacts/ArtifactSynchronizer", "beforeModuleRemoved"));
        }
        DMFacetBase facet = (DMFacetBase)((Object)DMFacetFinder.getInstance().processModule(module));
        if (facet != null && !(artifactsForModule = WithModuleArtifactUtil.findWithModuleArtifactsFor(module)).isEmpty()) {
            ArtifactManager artifactManager = ArtifactManager.getInstance((Project)project);
            if (this.myArtifactRemovingModel == null) {
                this.myArtifactRemovingModel = artifactManager.createModifiableModel();
            }
            for (Artifact nextToRemove : artifactsForModule) {
                this.myArtifactRemovingModel.removeArtifact(nextToRemove);
            }
        }
    }

    public void beforeRootsChange(ModuleRootEvent event) {
    }

    public void rootsChanged(ModuleRootEvent event) {
        if (this.myArtifactRemovingModel != null) {
            new WriteAction(){

                protected void run(@NotNull Result result) throws Throwable {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/dmserver/artifacts/ArtifactSynchronizer$1", "run"));
                    }
                    ArtifactSynchronizer.this.myArtifactRemovingModel.commit();
                    ArtifactSynchronizer.this.myArtifactRemovingModel.dispose();
                }
            }.execute();
            this.myArtifactRemovingModel = null;
        }
    }
}

