/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.ui;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="RemoteMappingsManager", storages={@Storage(value="remote-mappings.xml")})
public class RemoteMappingsManager
implements PersistentStateComponent<State> {
    private State myState = new State();

    public static RemoteMappingsManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/remotesdk/ui/RemoteMappingsManager", "getInstance"));
        }
        return (RemoteMappingsManager)ServiceManager.getService((Project)project, RemoteMappingsManager.class);
    }

    @Nullable
    public State getState() {
        return this.myState;
    }

    public void loadState(State state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this.myState);
    }

    public void setForServer(@NotNull Mappings mappings) {
        if (mappings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mappings", "com/jetbrains/plugins/remotesdk/ui/RemoteMappingsManager", "setForServer"));
        }
        List<Mappings> list = this.myState.getList();
        Iterator<Mappings> iterator = list.iterator();
        while (iterator.hasNext()) {
            Mappings current = iterator.next();
            if (!mappings.getServerId().equals(current.getServerId())) continue;
            iterator.remove();
        }
        list.add(mappings);
    }

    @Nullable
    public Mappings getForServer(@NotNull String prefix, @NotNull String serverId) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/jetbrains/plugins/remotesdk/ui/RemoteMappingsManager", "getForServer"));
        }
        if (serverId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverId", "com/jetbrains/plugins/remotesdk/ui/RemoteMappingsManager", "getForServer"));
        }
        String compoundId = RemoteMappingsManager.combineWithPrefix(prefix, serverId);
        List<Mappings> list = this.myState.getList();
        for (Mappings mappings : list) {
            if (!compoundId.equals(mappings.getServerId())) continue;
            return mappings;
        }
        return null;
    }

    public Mappings create(@NotNull String prefix, @NotNull String serverId, @NotNull List<PathMappingSettings.PathMapping> settings) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/jetbrains/plugins/remotesdk/ui/RemoteMappingsManager", "create"));
        }
        if (serverId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverId", "com/jetbrains/plugins/remotesdk/ui/RemoteMappingsManager", "create"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/plugins/remotesdk/ui/RemoteMappingsManager", "create"));
        }
        Mappings mappings = new Mappings();
        mappings.setServerId(prefix, serverId);
        mappings.setSettings(settings);
        return mappings;
    }

    @NotNull
    private static String combineWithPrefix(String prefix, String serverId) {
        String string = prefix + "@" + serverId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/ui/RemoteMappingsManager", "combineWithPrefix"));
        }
        return string;
    }

    @Tag(value="remote-mappings")
    public static class Mappings {
        private String myServerId;
        private List<PathMappingSettings.PathMapping> mySettings = new ArrayList<PathMappingSettings.PathMapping>();
        private Map<String, String> myDisabled = new HashMap<String, String>();

        @Attribute(value="server-id")
        public String getServerId() {
            return this.myServerId;
        }

        @Tag(value="settings")
        public List<PathMappingSettings.PathMapping> getSettings() {
            return this.mySettings;
        }

        @Tag(value="disabled")
        public Map<String, String> getDisabled() {
            return this.myDisabled;
        }

        public void setSettings(List<PathMappingSettings.PathMapping> settings) {
            this.mySettings = settings;
        }

        public void setServerId(String serverId) {
            this.myServerId = serverId;
        }

        public void setServerId(String prefix, String serverId) {
            this.myServerId = RemoteMappingsManager.combineWithPrefix(prefix, serverId);
        }

        public void setDisabled(Map<String, String> disabled) {
            this.myDisabled = disabled;
        }
    }

    @Tag(value="state")
    public static class State {
        @Tag(value="list")
        private List<Mappings> myList = new ArrayList<Mappings>();

        public List<Mappings> getList() {
            return this.myList;
        }
    }
}

