/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.ui;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.remote.PathMappingProvider;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.plugins.remotesdk.ui.RemoteMappingsManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MappingsGatherer {
    @NotNull
    private final Project myProject;
    @NotNull
    private final RemoteSdkAdditionalData mySdkData;
    private final RemoteMappingsManager.Mappings myRemoteMappings;
    private boolean myAddUserDefined;
    private boolean myAddDisabled;

    public MappingsGatherer(@NotNull Project project, @NotNull RemoteSdkAdditionalData sdkData, @NotNull String prefix) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/remotesdk/ui/MappingsGatherer", "<init>"));
        }
        if (sdkData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkData", "com/jetbrains/plugins/remotesdk/ui/MappingsGatherer", "<init>"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/jetbrains/plugins/remotesdk/ui/MappingsGatherer", "<init>"));
        }
        this.myProject = project;
        this.mySdkData = sdkData;
        this.myRemoteMappings = RemoteMappingsManager.getInstance(project).getForServer(prefix, sdkData.connectionCredentials().getId());
    }

    public MappingsGatherer addUserDefined(boolean value) {
        this.myAddUserDefined = value;
        return this;
    }

    public MappingsGatherer addDisabled(boolean value) {
        this.myAddDisabled = value;
        return this;
    }

    public List<PathMappingSettings.PathMapping> assemble() throws ExecutionException, InterruptedException {
        HashMap<String, PathMappingSettings.PathMapping> map = new HashMap<String, PathMappingSettings.PathMapping>();
        for (PathMappingProvider mappingProvider : PathMappingProvider.getSuitableMappingProviders((RemoteSdkAdditionalData)this.mySdkData)) {
            PathMappingSettings providerSettings = mappingProvider.getPathMappingSettings(this.myProject, this.mySdkData);
            List mappings = providerSettings.getPathMappings();
            for (PathMappingSettings.PathMapping mapping : mappings) {
                if (!this.myAddDisabled && this.myRemoteMappings != null && Comparing.equal((String)mapping.getRemoteRoot(), (String)this.myRemoteMappings.getDisabled().get(mapping.getLocalRoot()))) continue;
                map.put(FileUtil.toSystemIndependentName((String)mapping.getLocalRoot()), mapping);
            }
        }
        if (this.myAddUserDefined && this.myRemoteMappings != null) {
            List<PathMappingSettings.PathMapping> settings = this.myRemoteMappings.getSettings();
            for (PathMappingSettings.PathMapping setting : settings) {
                map.put(FileUtil.toSystemIndependentName((String)setting.getLocalRoot()), setting);
            }
        }
        return new ArrayList<PathMappingSettings.PathMapping>(map.values());
    }
}

