/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.transport;

import com.intellij.openapi.diagnostic.Logger;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jetbrains.plugins.remotesdk.transport.JschChannelType;
import com.jetbrains.plugins.remotesdk.transport.JschProcess;
import com.jetbrains.plugins.remotesdk.transport.SshRemoteSession;
import com.jetbrains.plugins.remotesdk.transport.SshTransportException;
import java.io.IOException;
import java.io.InputStream;

public class JschExecProcess
extends JschProcess {
    private static final Logger LOG = Logger.getInstance(JschExecProcess.class);
    private final ChannelExec myChannel;
    protected InputStream myErrorStream;
    private final boolean myHasPty;

    JschExecProcess(SshRemoteSession session, String command, int timeoutMs, boolean pty) throws IOException, SshTransportException {
        super(session);
        LOG.info("Executing ssh command: " + command + " for " + session.toString());
        this.myHasPty = pty;
        try {
            this.myChannel = (ChannelExec)this.mySession.openChannel(JschChannelType.EXEC);
            this.myChannel.setPty(pty);
            this.myChannel.setCommand(command);
            this.setupStreams();
            this.myChannel.connect(timeoutMs > 0 ? timeoutMs * 1000 : 0);
        }
        catch (JSchException e) {
            throw new SshTransportException(e.getMessage(), e);
        }
    }

    public ChannelExec getChannel() {
        return this.myChannel;
    }

    public boolean hasPty() {
        return this.myHasPty;
    }

    @Override
    protected void setupStreams() throws IOException {
        super.setupStreams();
        this.myErrorStream = this.getChannel().getErrStream();
    }

    public InputStream getErrorStream() {
        return this.myErrorStream;
    }
}

