/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.console;

import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSchException;
import com.jediterm.terminal.ProcessTtyConnector;
import com.jetbrains.plugins.remotesdk.transport.JschShellProcess;
import java.nio.charset.Charset;

public class JschProcessTtyConnector
extends ProcessTtyConnector {
    private final ChannelShell myChannel;
    private final String myHost;

    public JschProcessTtyConnector(JschShellProcess process, Charset charset) {
        super((Process)((Object)process), charset);
        this.myChannel = process.getChannel();
        try {
            this.myHost = this.myChannel.getSession().getHost();
        }
        catch (JSchException e) {
            throw new IllegalStateException("Should not happen", e);
        }
    }

    public void close() {
        this.myChannel.disconnect();
    }

    protected void resizeImmediately() {
        if (this.getPendingTermSize() != null && this.getPendingPixelSize() != null) {
            this.myChannel.setPtySize(this.getPendingTermSize().width, this.getPendingTermSize().height, this.getPendingPixelSize().width, this.getPendingPixelSize().height);
        }
    }

    public boolean isConnected() {
        return this.myChannel != null && this.myChannel.isConnected();
    }

    public String getName() {
        return this.myHost;
    }
}

