/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.j2ee.web.resin.ui;

import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.transport.TransportManager;
import com.intellij.javaee.transport.TransportManagerConfigurable;
import com.intellij.javaee.transport.TransportTarget;
import com.intellij.javaee.transport.TransportTargetConfigurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.intellij.j2ee.web.resin.ResinBundle;
import org.intellij.j2ee.web.resin.ResinRemoteModel;
import org.intellij.j2ee.web.resin.resin.jmx.ConnectorPingCommand;
import org.intellij.j2ee.web.resin.ui.ResinRunConfigurationEditorBase;
import org.intellij.j2ee.web.resin.ui.RunConfigurationEditor;
import org.jetbrains.annotations.NotNull;

public class RemoteRunConfigurationEditor
extends ResinRunConfigurationEditorBase {
    private JPanel myRootPanel;
    private JTextField myJmxPortField;
    private JButton myPingButton;
    private TransportManagerConfigurable myTransportManagerConfigurable;
    private TransportTargetConfigurable myDeploymentTransportTargetConfigurable;
    private JTextField myCharsetField;
    private JLabel myJmxPortLabel;
    private final Project myProject;
    private ResinRemoteModel myServerModel;
    private TransportTarget myDeploymentTransportTarget;

    public RemoteRunConfigurationEditor(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/j2ee/web/resin/ui/RemoteRunConfigurationEditor", "<init>"));
        }
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myPingButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RemoteRunConfigurationEditor.this.onPingButton();
            }
        });
        this.myDeploymentTransportTargetConfigurable.setParentConfigurable(this.myTransportManagerConfigurable);
    }

    private Project getProject() {
        return this.myProject;
    }

    private void onPingButton() {
        int jmxPort;
        try {
            jmxPort = this.parseJmxPort();
        }
        catch (ConfigurationException e) {
            return;
        }
        Ref success = new Ref(null);
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            try {
                Boolean pingResult = (Boolean)new ConnectorPingCommand(this.myServerModel, jmxPort).execute();
                success.set((Object)(pingResult != null && pingResult != false ? 1 : 0));
            }
            catch (Exception ex) {
                success.set((Object)false);
            }
        }, ResinBundle.message("RemoteRunConfigurationEditor.message.ping.operation-name", new Object[0]), true, this.getProject())) {
            return;
        }
        if (success.isNull()) {
            return;
        }
        String ping = ResinBundle.message("RemoteRunConfigurationEditor.message.ping", new Object[0]);
        if (((Boolean)success.get()).booleanValue()) {
            Messages.showInfoMessage((String)ResinBundle.message("RemoteRunConfigurationEditor.message.ping.ok", new Object[0]), (String)ping);
        } else {
            Messages.showErrorDialog((String)ResinBundle.message("RemoteRunConfigurationEditor.message.ping.failed", new Object[0]), (String)ping);
        }
    }

    private int parseJmxPort() throws ConfigurationException {
        return RunConfigurationEditor.parseInt(this.myJmxPortField, "run.config.dlg.jmx.port.error");
    }

    protected void resetEditorFrom(CommonModel s) {
        this.myServerModel = (ResinRemoteModel)s.getServerModel();
        this.myCharsetField.setText(this.myServerModel.getCharset());
        this.myJmxPortField.setText(String.valueOf(this.myServerModel.getJmxPort()));
        this.myTransportManagerConfigurable.setHostId(this.myServerModel.getTransportHostId(), this.myServerModel.getProject());
        this.myDeploymentTransportTarget = RemoteRunConfigurationEditor.getOrCreateTransportTarget(this.myServerModel.getTransportTargetWebApps());
        this.myDeploymentTransportTargetConfigurable.setTarget(this.myDeploymentTransportTarget);
        this.updateJmxPortVisible(this.myServerModel);
    }

    protected void applyEditorTo(CommonModel s) throws ConfigurationException {
        ResinRemoteModel serverModel = (ResinRemoteModel)s.getServerModel();
        serverModel.setJmxPort(this.parseJmxPort());
        serverModel.setCharset(this.myCharsetField.getText());
        serverModel.setTransportHostId(this.myTransportManagerConfigurable.getHostId());
        serverModel.setTransportTargetWebApps(this.myDeploymentTransportTarget);
        this.myDeploymentTransportTargetConfigurable.saveState();
    }

    private static TransportTarget getOrCreateTransportTarget(TransportTarget target) {
        return target == null || target.getId() == null ? TransportManager.createTarget() : target;
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myRootPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/j2ee/web/resin/ui/RemoteRunConfigurationEditor", "createEditor"));
        }
        return jPanel;
    }

    @Override
    protected void setJmxPortVisible(boolean visible) {
        this.myJmxPortLabel.setVisible(visible);
        this.myJmxPortField.setVisible(visible);
        this.myPingButton.setVisible(visible);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JButton jButton;
        TransportTargetConfigurable transportTargetConfigurable;
        TransportManagerConfigurable transportManagerConfigurable;
        JTextField jTextField2;
        JLabel jLabel;
        JPanel jPanel;
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myJmxPortLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("org/intellij/j2ee/web/resin/ResinBundle").getString("Form.RemoteRunConfigurationEditor.jmx.port"));
        jPanel.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myJmxPortField = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(1, 1, 1, 1, 8, 1, 0, 0, null, new Dimension(80, -1), null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(2, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("org/intellij/j2ee/web/resin/ResinBundle").getString("Form.RemoteRunConfigurationEditor.remote.staging"), (int)0, (int)0, null, null));
        this.myTransportManagerConfigurable = transportManagerConfigurable = new TransportManagerConfigurable();
        JComponent jComponent = transportManagerConfigurable.$$$getRootComponent$$$();
        jPanel2.add((Component)jComponent, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("org/intellij/j2ee/web/resin/ResinBundle").getString("Form.RemoteRunConfigurationEditor.webapps.target"), (int)0, (int)0, null, null));
        this.myDeploymentTransportTargetConfigurable = transportTargetConfigurable = new TransportTargetConfigurable();
        JComponent jComponent2 = transportTargetConfigurable.$$$getRootComponent$$$();
        jPanel3.add((Component)jComponent2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myPingButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("org/intellij/j2ee/web/resin/ResinBundle").getString("Form.RemoteRunConfigurationEditor.ping"));
        jPanel.add((Component)jButton, new GridConstraints(1, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCharsetField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 0, 0, null, new Dimension(80, -1), null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("org/intellij/j2ee/web/resin/ResinBundle").getString("run.config.dlg.charset"));
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        jLabel.setLabelFor(jTextField2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

