/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.j2ee.web.resin.resin.version;

import java.io.File;
import org.intellij.j2ee.web.resin.resin.version.ResinVersion;
import org.intellij.j2ee.web.resin.resin.version.ResinVersionDetector;
import org.jetbrains.annotations.NotNull;

public class GenericResinVersion
extends ResinVersion {
    private final String myStartupClass;
    private final boolean myAllowXdebug;
    private final boolean myAllowJmx;

    public GenericResinVersion(String name, String versionNumber, @NotNull String startupClass, boolean allowXdebug, boolean allowJmx) {
        if (startupClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startupClass", "org/intellij/j2ee/web/resin/resin/version/GenericResinVersion", "<init>"));
        }
        super(name, versionNumber);
        this.myStartupClass = startupClass;
        this.myAllowXdebug = allowXdebug;
        this.myAllowJmx = allowJmx;
    }

    @Override
    public boolean isOfVersion(File resinHome) {
        ResinVersion ver = ResinVersionDetector.getResinVersion(resinHome);
        return this.equals(ver);
    }

    @Override
    public String getStartupClass() {
        return this.myStartupClass;
    }

    @Override
    public boolean allowXdebug() {
        return this.myAllowXdebug;
    }

    @Override
    public boolean allowJmx() {
        return this.myAllowJmx;
    }
}

