/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.openshift.agent.cloud;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.transport.JschSession;
import org.eclipse.jgit.transport.URIish;

public class PatchedRemoteSession
extends JschSession {
    private final Session mySession;
    private final URIish myURIish;

    public PatchedRemoteSession(Session session, URIish uri) {
        super(session, uri);
        this.mySession = session;
        this.myURIish = uri;
    }

    public Process startShell() throws IOException {
        return new PatchedJschProcess();
    }

    private class PatchedJschProcess
    extends Process {
        private static final String EXEC_CHANNEL_TYPE = "exec";
        private Channel myChannel;
        private InputStream myInputStream;
        private OutputStream myOutputStream;

        private PatchedJschProcess() throws IOException {
            try {
                this.myChannel = PatchedRemoteSession.this.mySession.openChannel(EXEC_CHANNEL_TYPE);
                ((ChannelExec)this.myChannel).setPty(true);
                this.myInputStream = this.myChannel.getInputStream();
                this.myOutputStream = this.myChannel.getOutputStream();
                this.myChannel.connect();
                if (!this.myChannel.isConnected()) {
                    throw new TransportException(PatchedRemoteSession.this.myURIish, "connection failed");
                }
            }
            catch (JSchException e) {
                throw new TransportException(PatchedRemoteSession.this.myURIish, e.getMessage(), (Throwable)e);
            }
        }

        @Override
        public InputStream getInputStream() {
            return this.myInputStream;
        }

        @Override
        public OutputStream getOutputStream() {
            return this.myOutputStream;
        }

        @Override
        public InputStream getErrorStream() {
            return null;
        }

        @Override
        public int exitValue() {
            if (this.isRunning()) {
                throw new IllegalStateException();
            }
            return this.myChannel.getExitStatus();
        }

        private boolean isRunning() {
            return this.myChannel.getExitStatus() < 0 && this.myChannel.isConnected();
        }

        @Override
        public void destroy() {
            if (this.myChannel.isConnected()) {
                this.myChannel.disconnect();
            }
        }

        @Override
        public int waitFor() throws InterruptedException {
            while (this.isRunning()) {
                Thread.sleep(100L);
            }
            return this.exitValue();
        }
    }
}

