/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.openshift.agent.cloud;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.UnknownHostException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.CredentialsProviderUserInfo;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.FS;

public abstract class PatchedJschConfigSessionFactory
extends JschConfigSessionFactory {
    private OpenSshConfig myOpenSshConfig;

    protected synchronized Session getSession(URIish uri) throws TransportException {
        CredentialsProvider credentialsProvider = CredentialsProvider.getDefault();
        FS fs = FS.DETECTED;
        String user = uri.getUser();
        String pass = uri.getPass();
        String host = uri.getHost();
        int port = uri.getPort();
        try {
            if (this.myOpenSshConfig == null) {
                this.myOpenSshConfig = OpenSshConfig.get((FS)fs);
            }
            OpenSshConfig.Host hc = this.myOpenSshConfig.lookup(host);
            host = hc.getHostName();
            if (port <= 0) {
                port = hc.getPort();
            }
            if (user == null) {
                user = hc.getUser();
            }
            Session session = this.createSession(credentialsProvider, fs, user, pass, host, port, hc);
            int retries = 0;
            while (!session.isConnected() && retries < 3) {
                try {
                    ++retries;
                    session.connect(0);
                }
                catch (JSchException e) {
                    session.disconnect();
                    session = null;
                    PatchedJschConfigSessionFactory.knownHosts(this.getJSch(hc, fs), fs);
                    if (credentialsProvider != null && e.getCause() == null && e.getMessage().equals("Auth fail") && retries < 3) {
                        credentialsProvider.reset(uri);
                        session = this.createSession(credentialsProvider, fs, user, pass, host, port, hc);
                        continue;
                    }
                    throw e;
                }
            }
            return session;
        }
        catch (JSchException je) {
            Throwable c = je.getCause();
            if (c instanceof UnknownHostException) {
                throw new TransportException(uri, JGitText.get().unknownHost);
            }
            if (c instanceof ConnectException) {
                throw new TransportException(uri, c.getMessage());
            }
            throw new TransportException(uri, je.getMessage(), (Throwable)je);
        }
    }

    private Session createSession(CredentialsProvider credentialsProvider, FS fs, String user, String pass, String host, int port, OpenSshConfig.Host hc) throws JSchException {
        String pauth;
        String strictHostKeyCheckingPolicy;
        Session session = this.createSession(hc, user, host, port, fs);
        session.setConfig("MaxAuthTries", "1");
        if (pass != null) {
            session.setPassword(pass);
        }
        if ((strictHostKeyCheckingPolicy = hc.getStrictHostKeyChecking()) != null) {
            session.setConfig("StrictHostKeyChecking", strictHostKeyCheckingPolicy);
        }
        if ((pauth = hc.getPreferredAuthentications()) != null) {
            session.setConfig("PreferredAuthentications", pauth);
        }
        if (!(credentialsProvider == null || hc.isBatchMode() && credentialsProvider.isInteractive())) {
            session.setUserInfo((UserInfo)new CredentialsProviderUserInfo(session, credentialsProvider));
        }
        this.configure(hc, session);
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void knownHosts(JSch sch, FS fs) throws JSchException {
        File home = fs.userHome();
        if (home == null) {
            return;
        }
        File known_hosts = new File(new File(home, ".ssh"), "known_hosts");
        try {
            FileInputStream in = new FileInputStream(known_hosts);
            try {
                sch.setKnownHosts((InputStream)in);
            }
            finally {
                in.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

