/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.openshift.agent.cloud;

import com.intellij.javaee.openshift.agent.cloud.OSApiTaskProvider;
import com.intellij.javaee.openshift.agent.cloud.OSAppSSHSessionFactory;
import com.intellij.javaee.openshift.agent.cloud.OSApplicationImpl;
import com.intellij.javaee.openshift.agent.cloud.OSCloudAgent;
import com.intellij.javaee.openshift.agent.cloud.OSCloudAgentConfig;
import com.intellij.javaee.openshift.agent.cloud.OSCloudAgentDeployment;
import com.intellij.javaee.openshift.agent.cloud.OSCloudAgentDeploymentImpl;
import com.intellij.javaee.openshift.agent.cloud.OSDomainConfiguration;
import com.intellij.remoteServer.agent.util.CloudAgentErrorHandler;
import com.intellij.remoteServer.agent.util.CloudAgentLogger;
import com.intellij.remoteServer.agent.util.CloudAgentLoggingHandler;
import com.intellij.remoteServer.agent.util.CloudRemoteApplication;
import com.intellij.remoteServer.agent.util.log.LogAgentManager;
import com.openshift.client.IApplication;
import com.openshift.client.IDomain;
import com.openshift.client.IGearProfile;
import com.openshift.client.IOpenShiftConnection;
import com.openshift.client.ISSHPublicKey;
import com.openshift.client.IUser;
import com.openshift.client.OpenShiftConnectionFactory;
import com.openshift.client.OpenShiftException;
import com.openshift.client.SSHPublicKey;
import com.openshift.client.cartridge.IEmbeddableCartridge;
import com.openshift.client.cartridge.IStandaloneCartridge;
import com.openshift.client.cartridge.selector.LatestVersionOf;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class OSCloudAgentImpl
implements OSCloudAgent {
    private static final String CLIENT_ID = "IDEA-OpenShift-integration";
    private LogAgentManager myLogManager = new LogAgentManager();
    private OSApiTaskProvider myTaskProvider;
    private CloudAgentLogger myLogger;
    private IOpenShiftConnection myConnection;
    private IDomain myDomain;
    private OSAppSSHSessionFactory mySessionFactory;
    private List<OSCloudAgentDeploymentImpl> myCloudAgentDeployments = new ArrayList<OSCloudAgentDeploymentImpl>();

    public void connect(OSCloudAgentConfig config, CloudAgentErrorHandler errorHandler, CloudAgentLogger logger) {
        try {
            this.myLogger = logger;
            if (this.myConnection == null) {
                String username = config.getEmail();
                String password = config.getPassword();
                String libraServer = config.getLibraServer();
                this.myConnection = new OpenShiftConnectionFactory().getConnection(CLIENT_ID, username, password, libraServer);
            }
            this.mySessionFactory = new OSAppSSHSessionFactory(config);
            IUser user = this.myConnection.getUser();
            String domainName = config.getDomain();
            if (domainName != null && !domainName.isEmpty()) {
                if (!user.hasDomain(domainName)) {
                    throw new OpenShiftException("Domain " + domainName + " not found", new Object[0]);
                }
                this.myDomain = user.getDomain(domainName);
            } else {
                this.myDomain = user.getDefaultDomain();
            }
            if (this.myDomain == null) {
                throw new OpenShiftException("Unable to obtain domain", new Object[0]);
            }
            this.myTaskProvider = new OSApiTaskProvider(this.myDomain, errorHandler, logger);
        }
        catch (OpenShiftException e) {
            errorHandler.onError(e.toString());
        }
    }

    public OSCloudAgentDeployment createDeployment(String deploymentName, CloudAgentLoggingHandler loggingHandler) {
        OSCloudAgentDeploymentImpl agentDeployment = new OSCloudAgentDeploymentImpl(this.myTaskProvider, deploymentName, loggingHandler, this.myLogManager, this.myLogger, this.mySessionFactory);
        this.myCloudAgentDeployments.add(agentDeployment);
        return agentDeployment;
    }

    public void disconnect() {
        this.myLogManager.stopListeningAllLogs();
        this.stopAllDebugPortForwarding();
    }

    public void stopAllDebugPortForwarding() {
        new OSApiTaskProvider.ApiTask(this.myTaskProvider){

            protected Object doPerform(IDomain domain) throws OpenShiftException {
                for (OSCloudAgentDeploymentImpl agentDeployment : OSCloudAgentImpl.this.myCloudAgentDeployments) {
                    agentDeployment.doStopDebugPortForwarding(domain);
                }
                return null;
            }
        }.perform();
    }

    public CloudRemoteApplication[] getApplications() {
        return (CloudRemoteApplication[])new OSApiTaskProvider.ApiTask<CloudRemoteApplication[]>(this.myTaskProvider){

            @Override
            protected CloudRemoteApplication[] doPerform(IDomain domain) throws OpenShiftException {
                ArrayList<OSApplicationImpl> result = new ArrayList<OSApplicationImpl>();
                for (IApplication app : domain.getApplications()) {
                    result.add(new OSApplicationImpl(app));
                }
                return result.toArray(new CloudRemoteApplication[result.size()]);
            }
        }.perform();
    }

    public void addSshKeyFile(final File sshKeyFile) {
        OSApiTaskProvider oSApiTaskProvider = this.myTaskProvider;
        oSApiTaskProvider.getClass();
        new OSApiTaskProvider.ApiTask(oSApiTaskProvider){

            protected Object doPerform(IDomain domain) throws OpenShiftException, IOException {
                IUser user = OSCloudAgentImpl.this.myConnection.getUser();
                SSHPublicKey sshPublicKey = new SSHPublicKey(sshKeyFile);
                user.putSSHKey(sshKeyFile.getName(), (ISSHPublicKey)sshPublicKey);
                return null;
            }
        }.perform();
    }

    public String[] getAvailableDomains() {
        ArrayList<String> domains = new ArrayList<String>();
        for (IDomain domain : this.myConnection.getDomains()) {
            domains.add(domain.getId());
        }
        return domains.toArray(new String[domains.size()]);
    }

    public OSDomainConfiguration getConfigurationDomain() {
        return new OSDomainConfigurationImpl();
    }

    public static IStandaloneCartridge getDefaultStandaloneCartridge(IUser user) {
        return LatestVersionOf.jbossAs().get(user);
    }

    private List<IStandaloneCartridge> sort(List<IStandaloneCartridge> cartridges) {
        cartridges = new ArrayList<IStandaloneCartridge>(cartridges);
        ArrayList<IStandaloneCartridge> result = new ArrayList<IStandaloneCartridge>();
        IStandaloneCartridge defaultCartridge = OSCloudAgentImpl.getDefaultStandaloneCartridge(this.myConnection.getUser());
        cartridges.remove(defaultCartridge);
        result.add(defaultCartridge);
        Iterator<IStandaloneCartridge> cartridge = cartridges.iterator();
        while (cartridge.hasNext()) {
            IStandaloneCartridge currentCartridge = cartridge.next();
            if (!currentCartridge.getName().contains("jboss")) continue;
            result.add(currentCartridge);
            cartridge.remove();
        }
        result.addAll(cartridges);
        return result;
    }

    private class OSDomainConfigurationImpl
    implements OSDomainConfiguration {
        private List<String> myGearSizes = new ArrayList<String>();
        private List<String> myEmbeddableCartridges = new ArrayList<String>();
        private List<String> myStandaloneCartridges = new ArrayList<String>();

        public OSDomainConfigurationImpl() {
            List embeddableCartridges = OSCloudAgentImpl.this.myConnection.getEmbeddableCartridges();
            List standaloneCartridges = OSCloudAgentImpl.this.sort(OSCloudAgentImpl.this.myConnection.getStandaloneCartridges());
            List gearProfiles = OSCloudAgentImpl.this.myDomain.getAvailableGearProfiles();
            for (IGearProfile gear : gearProfiles) {
                if (gear == null) continue;
                this.myGearSizes.add(gear.getName());
            }
            for (IEmbeddableCartridge cartridge : embeddableCartridges) {
                if (cartridge == null) continue;
                this.myEmbeddableCartridges.add(cartridge.getName());
            }
            for (IEmbeddableCartridge cartridge : standaloneCartridges) {
                if (cartridge == null) continue;
                this.myStandaloneCartridges.add(cartridge.getName());
            }
        }

        public String[] getGearSizes() {
            return this.myGearSizes.toArray(new String[this.myGearSizes.size()]);
        }

        public String[] getStandaloneCartridges() {
            return this.myStandaloneCartridges.toArray(new String[this.myStandaloneCartridges.size()]);
        }

        public String[] getEmbeddableCartridges() {
            return this.myEmbeddableCartridges.toArray(new String[this.myEmbeddableCartridges.size()]);
        }
    }
}

