/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.openshift.agent.cloud;

import com.intellij.javaee.openshift.agent.cloud.OSCloudAgentConfig;
import com.intellij.javaee.openshift.agent.cloud.PatchedJschConfigSessionFactory;
import com.intellij.javaee.openshift.agent.cloud.PatchedRemoteSession;
import com.intellij.remoteServer.agent.util.CloudProxySettings;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.ProxyHTTP;
import com.jcraft.jsch.Session;
import com.openshift.client.IApplication;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.URIish;

public class OSAppSSHSessionFactory
extends PatchedJschConfigSessionFactory {
    private static final int SSH_PORT = 22;
    private final Map<URIish, Session> mySessionsStorage = new HashMap<URIish, Session>();
    private final CloudProxySettings myProxySettings;

    public OSAppSSHSessionFactory(OSCloudAgentConfig cloudConfig) {
        this.myProxySettings = cloudConfig.getProxySettings();
    }

    public void setupAppSession(IApplication application) throws MalformedURLException, TransportException {
        URIish sshUri = OSAppSSHSessionFactory.getSshUri(application);
        Session session = this.mySessionsStorage.get(sshUri);
        if (session == null || !session.isConnected()) {
            session = this.getSession(sshUri);
            this.mySessionsStorage.put(sshUri, session);
        }
        application.setSSHSession(session);
    }

    public PatchedRemoteSession getRemoteSession(IApplication application) throws MalformedURLException, TransportException {
        URIish uri = OSAppSSHSessionFactory.getSshUri(application);
        Session session = this.getSession(uri);
        return new PatchedRemoteSession(session, uri);
    }

    private static URIish getSshUri(IApplication application) throws MalformedURLException {
        return new URIish().setHost(new URL(application.getApplicationUrl()).getHost()).setUser(application.getUUID()).setPort(22);
    }

    protected void configure(OpenSshConfig.Host hc, Session session) {
        if (this.myProxySettings.useHttpProxy()) {
            ProxyHTTP proxy = new ProxyHTTP(this.myProxySettings.getHost(), this.myProxySettings.getPort());
            if (this.myProxySettings.useAuthentication()) {
                proxy.setUserPasswd(this.myProxySettings.getLogin(), this.myProxySettings.getPassword());
            }
            session.setProxy((Proxy)proxy);
        }
    }
}

