/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.openshift.agent.cloud;

import com.intellij.javaee.openshift.agent.cloud.ApiTask;
import com.intellij.javaee.openshift.agent.cloud.OS3AgentTemplate;
import com.intellij.javaee.openshift.agent.cloud.OS3Context;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3AgentDeployment;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3AgentException;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3CloudAgentDeploymentConfig;
import com.openshift.internal.restclient.ResourceFactory;
import com.openshift.internal.restclient.capability.resources.ProjectTemplateProcessing;
import com.openshift.internal.restclient.model.Status;
import com.openshift.restclient.IClient;
import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.capability.CapabilityVisitor;
import com.openshift.restclient.capability.resources.IClientCapability;
import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.template.ITemplate;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class OS3AgentDeploymentImpl
implements OS3AgentDeployment {
    private final OS3CloudAgentDeploymentConfig myDeploymentConfig;
    private final OS3Context myContext;

    public OS3AgentDeploymentImpl(OS3CloudAgentDeploymentConfig config, OS3Context context) {
        this.myDeploymentConfig = config;
        this.myContext = context;
    }

    private IClient getClient() {
        return this.myContext.getClient();
    }

    public void deployLocalTemplate() {
        new CreateApplicationApiTask(){

            @Override
            protected ITemplate getOrCreateTemplate() throws IOException {
                return (ITemplate)new ResourceFactory(OS3AgentDeploymentImpl.this.getClient()).create((InputStream)new FileInputStream(OS3AgentDeploymentImpl.this.myDeploymentConfig.getFile()));
            }
        }.perform();
    }

    public void deployServerTemplate() {
        new CreateApplicationApiTask(){

            @Override
            protected ITemplate getOrCreateTemplate() {
                List serverTemplates = OS3AgentDeploymentImpl.this.getClient().list("Template");
                for (ITemplate serverTemplate : serverTemplates) {
                    if (!OS3AgentDeploymentImpl.this.myDeploymentConfig.getTemplateName().equals(new OS3AgentTemplate(serverTemplate).getApplicationName())) continue;
                    return serverTemplate;
                }
                return null;
            }
        }.perform();
    }

    private String createErrorStatusForExistingResources(Collection<IResource> resources) {
        StringBuilder errorStatus = new StringBuilder("\nThe following resource names already exist:\n");
        OS3AgentDeploymentImpl.createErrorStatus(resources, errorStatus);
        errorStatus.append("\n\nYou need to use different names or create this application in a different OpenShift project.");
        return errorStatus.toString();
    }

    private static void createErrorStatus(Collection<IResource> resources, StringBuilder errorStatus) {
        for (IResource resource : resources) {
            errorStatus.append("\n\"").append(resource.getName()).append("\" ").append(resource.getKind());
        }
    }

    private Collection<IResource> findExistingResources(final IProject project, final ITemplate template) {
        return (Collection)project.accept((CapabilityVisitor)new CapabilityVisitor<IClientCapability, Collection<IResource>>(){

            public Collection<IResource> visit(IClientCapability capability) {
                ArrayList<IResource> existing = new ArrayList<IResource>();
                for (IResource resource : template.getItems()) {
                    IResource found = this.findExisting(resource);
                    if (found == null) continue;
                    existing.add(found);
                }
                return existing;
            }

            private IResource findExisting(IResource resource) {
                try {
                    return OS3AgentDeploymentImpl.this.getClient().get(resource.getKind(), resource.getName(), project.getName());
                }
                catch (OpenShiftException e) {
                    return null;
                }
            }
        }, Collections.emptyList());
    }

    private IProject getProjectByName(String projectName) throws OS3AgentException {
        List projects = this.getClient().list("Project");
        for (IProject project : projects) {
            if (!project.getName().equals(projectName)) continue;
            return project;
        }
        throw new OS3AgentException("'" + projectName + "' project has not been found.");
    }

    public String getName() {
        throw new UnsupportedOperationException();
    }

    public String getWebUrl() {
        throw new UnsupportedOperationException();
    }

    private abstract class CreateApplicationApiTask
    extends ApiTask {
        public CreateApplicationApiTask() {
            super(OS3AgentDeploymentImpl.this.myContext.getErrorHandler());
        }

        protected Object doPerform() throws OpenShiftException, IOException, OS3AgentException {
            IProject project = OS3AgentDeploymentImpl.this.getProjectByName(OS3AgentDeploymentImpl.this.myDeploymentConfig.getProjectName());
            ProjectTemplateProcessing capability = new ProjectTemplateProcessing(project, OS3AgentDeploymentImpl.this.getClient());
            ITemplate template = this.getOrCreateTemplate();
            if (template == null) {
                throw new OS3AgentException("Can't find server template.");
            }
            Arrays.asList(OS3AgentDeploymentImpl.this.myDeploymentConfig.getTemplateParameters()).forEach(templateParameter -> template.updateParameter(templateParameter.getName(), templateParameter.getValue()));
            ITemplate processed = capability.process(template);
            Collection existing = OS3AgentDeploymentImpl.this.findExistingResources(project, processed);
            if (!existing.isEmpty()) {
                throw new OS3AgentException(OS3AgentDeploymentImpl.this.createErrorStatusForExistingResources(existing));
            }
            Collection resources = capability.apply(processed);
            StringBuilder errors = new StringBuilder();
            resources.stream().filter(resource -> resource.getKind().equals("Status") && resource instanceof Status && ((Status)resource).getStatus().equals("Failure")).forEach(resource -> OS3AgentDeploymentImpl.createErrorStatus(resources, errors));
            String errorText = errors.toString();
            if (!errorText.isEmpty()) {
                throw new OS3AgentException(errorText);
            }
            return null;
        }

        protected abstract ITemplate getOrCreateTemplate() throws IOException;
    }
}

