/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.openshift.agent.cloud;

import com.intellij.javaee.openshift.agent.cloud.os3.OS3AgentException;
import com.intellij.remoteServer.agent.util.CloudAgentErrorHandler;
import com.openshift.restclient.OpenShiftException;
import java.io.IOException;

public abstract class ApiTask<T> {
    private final CloudAgentErrorHandler myErrorHandler;

    public ApiTask(CloudAgentErrorHandler errorHandler) {
        this.myErrorHandler = errorHandler;
    }

    public T perform() {
        try {
            return this.doPerform();
        }
        catch (OpenShiftException ex) {
            this.onError(ex.toString());
            return null;
        }
        catch (RuntimeException ex) {
            this.onError(ex.toString());
            return null;
        }
        catch (IOException ex) {
            this.onError(ex.toString());
            return null;
        }
        catch (OS3AgentException ex) {
            this.onError(ex.toString());
            return null;
        }
    }

    protected void onError(String error) {
        this.myErrorHandler.onError(error);
    }

    protected abstract T doPerform() throws OpenShiftException, IOException, OS3AgentException;
}

