/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.util.ScalableIcon;
import java.awt.Component;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.plaf.UIResource;
import org.jetbrains.annotations.NotNull;

public class EmptyIcon
implements Icon,
ScalableIcon {
    private static final Map<Integer, Icon> cache = new HashMap<Integer, Icon>();
    public static final Icon ICON_16 = EmptyIcon.create(16);
    public static final Icon ICON_18 = EmptyIcon.create(18);
    public static final Icon ICON_8 = EmptyIcon.create(8);
    public static final Icon ICON_0 = EmptyIcon.create(0);
    private final int width;
    private final int height;
    protected float scale;
    private EmptyIcon myScaledCache;

    public static Icon create(int size) {
        Icon icon = cache.get(size);
        if (icon == null && size < 129) {
            icon = new EmptyIcon(size, size);
            cache.put(size, icon);
        }
        return icon == null ? new EmptyIcon(size, size) : icon;
    }

    public static Icon create(int width, int height) {
        return width == height ? EmptyIcon.create(width) : new EmptyIcon(width, height);
    }

    public static Icon create(@NotNull Icon base) {
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/util/ui/EmptyIcon", "create"));
        }
        return EmptyIcon.create(base.getIconWidth(), base.getIconHeight());
    }

    public EmptyIcon(int size) {
        this(size, size);
    }

    public EmptyIcon(int width, int height) {
        this.scale = 1.0f;
        this.width = width;
        this.height = height;
    }

    public EmptyIcon(@NotNull Icon base) {
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/util/ui/EmptyIcon", "<init>"));
        }
        this(base.getIconWidth(), base.getIconHeight());
    }

    @Override
    public int getIconWidth() {
        return this.scale(this.width);
    }

    @Override
    public int getIconHeight() {
        return this.scale(this.height);
    }

    @Override
    public void paintIcon(Component component, Graphics g, int i, int j) {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EmptyIcon)) {
            return false;
        }
        EmptyIcon icon = (EmptyIcon)o;
        if (this.height != icon.height) {
            return false;
        }
        if (this.width != icon.width) {
            return false;
        }
        return this.scale == icon.scale;
    }

    public int hashCode() {
        int result = this.width;
        result = 31 * result + this.height;
        result = 31 * result + (this.scale != 0.0f ? Float.floatToIntBits(this.scale) : 0);
        return result;
    }

    public EmptyIconUIResource asUIResource() {
        return new EmptyIconUIResource(this);
    }

    protected int scale(int n) {
        return this.scale == 1.0f ? n : (int)((float)n * this.scale);
    }

    @Override
    public Icon scale(float scaleFactor) {
        if (this.scale == scaleFactor) {
            return this;
        }
        if (this.myScaledCache != null && this.myScaledCache.scale == scaleFactor) {
            return this.myScaledCache;
        }
        this.myScaledCache = this.createScaledInstance(scaleFactor);
        this.myScaledCache.scale = scaleFactor;
        return this.myScaledCache;
    }

    protected EmptyIcon createScaledInstance(float scale) {
        EmptyIcon icon = scale != 1.0f ? this : (this instanceof UIResource ? new EmptyIconUIResource(this.width, this.height) : new EmptyIcon(this.width, this.height));
        return icon;
    }

    public static class EmptyIconUIResource
    extends EmptyIcon
    implements UIResource {
        public EmptyIconUIResource(EmptyIcon icon) {
            super(icon.width, icon.height);
        }

        private EmptyIconUIResource(int width, int height) {
            super(width, height);
        }
    }
}

