/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.AppleHiDPIScaledImage;
import com.intellij.util.ImageLoader;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.ui.UIUtil;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import org.jetbrains.annotations.NotNull;

public class RetinaImage {
    public static Image createFrom(Image image) {
        return RetinaImage.createFrom(image, 2, ImageLoader.ourComponent);
    }

    @NotNull
    public static Image createFrom(Image image, int scale, ImageObserver observer) {
        int w = image.getWidth(observer);
        int h = image.getHeight(observer);
        BufferedImage hidpi = RetinaImage.create(image, w / scale, h / scale, 2);
        if (SystemInfo.isAppleJvm) {
            Graphics2D g = (Graphics2D)((Image)hidpi).getGraphics();
            g.scale(1.0f / (float)scale, 1.0f / (float)scale);
            g.drawImage(image, 0, 0, null);
            g.dispose();
        }
        BufferedImage bufferedImage = hidpi;
        if (bufferedImage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/RetinaImage", "createFrom"));
        }
        return bufferedImage;
    }

    @NotNull
    public static BufferedImage create(int width, int height, int type) {
        BufferedImage bufferedImage = RetinaImage.create(null, width, height, type);
        if (bufferedImage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/RetinaImage", "create"));
        }
        return bufferedImage;
    }

    @NotNull
    private static BufferedImage create(Image image, int width, int height, int type) {
        if (SystemInfo.isAppleJvm) {
            BufferedImage bufferedImage = AppleHiDPIScaledImage.create(width, height, type);
            if (bufferedImage == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/RetinaImage", "create"));
            }
            return bufferedImage;
        }
        if (image == null) {
            JBHiDPIScaledImage jBHiDPIScaledImage = new JBHiDPIScaledImage(width, height, type);
            if (jBHiDPIScaledImage == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/RetinaImage", "create"));
            }
            return jBHiDPIScaledImage;
        }
        JBHiDPIScaledImage jBHiDPIScaledImage = new JBHiDPIScaledImage(image, width, height, type);
        if (jBHiDPIScaledImage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/RetinaImage", "create"));
        }
        return jBHiDPIScaledImage;
    }

    public static boolean isAppleHiDPIScaledImage(Image image) {
        return UIUtil.isAppleRetina() && AppleHiDPIScaledImage.is(image);
    }
}

