/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Factory;
import com.intellij.util.ArrayUtil;
import java.lang.reflect.Constructor;
import org.jetbrains.annotations.NotNull;

public class NewInstanceFactory<T>
implements Factory<T> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.NewInstanceFactory");
    private final Constructor<T> myConstructor;
    private final Object[] myArgs;

    private NewInstanceFactory(@NotNull Constructor<T> constructor, @NotNull Object[] args) {
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "com/intellij/util/NewInstanceFactory", "<init>"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/util/NewInstanceFactory", "<init>"));
        }
        this.myConstructor = constructor;
        this.myArgs = args;
    }

    @Override
    public T create() {
        try {
            return this.myConstructor.newInstance(this.myArgs);
        }
        catch (Exception e) {
            LOG.error(e);
            return null;
        }
    }

    public static <T> Factory<T> fromClass(final @NotNull Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/util/NewInstanceFactory", "fromClass"));
        }
        try {
            return new NewInstanceFactory<T>(clazz.getConstructor(ArrayUtil.EMPTY_CLASS_ARRAY), ArrayUtil.EMPTY_OBJECT_ARRAY);
        }
        catch (NoSuchMethodException e) {
            return new Factory<T>(){

                @Override
                public T create() {
                    try {
                        return clazz.newInstance();
                    }
                    catch (Exception e) {
                        LOG.error(e);
                        return null;
                    }
                }
            };
        }
    }
}

