/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.ThreadDump;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThreadDumper {
    private ThreadDumper() {
    }

    @NotNull
    public static String dumpThreadsToString() {
        StringWriter writer = new StringWriter();
        ThreadDumper.dumpThreadsToFile(ManagementFactory.getThreadMXBean(), writer);
        String string = writer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagnostic/ThreadDumper", "dumpThreadsToString"));
        }
        return string;
    }

    @NotNull
    public static String dumpEdtStackTrace(ThreadInfo[] threadInfos) {
        StringWriter writer = new StringWriter();
        if (threadInfos.length > 0) {
            StackTraceElement[] trace = threadInfos[0].getStackTrace();
            ThreadDumper.printStackTrace(writer, trace);
        }
        String string = writer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagnostic/ThreadDumper", "dumpEdtStackTrace"));
        }
        return string;
    }

    @NotNull
    public static ThreadInfo[] getThreadInfos() {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] threadInfoArray = ThreadDumper.sort(threadMXBean.dumpAllThreads(false, false));
        if (threadInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagnostic/ThreadDumper", "getThreadInfos"));
        }
        return threadInfoArray;
    }

    @NotNull
    public static ThreadDump getThreadDumpInfo(@NotNull ThreadMXBean threadMXBean) {
        if (threadMXBean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "threadMXBean", "com/intellij/diagnostic/ThreadDumper", "getThreadDumpInfo"));
        }
        StringWriter writer = new StringWriter();
        StackTraceElement[] edtStack = ThreadDumper.dumpThreadsToFile(threadMXBean, writer);
        ThreadDump threadDump = new ThreadDump(writer.toString(), edtStack);
        if (threadDump == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagnostic/ThreadDumper", "getThreadDumpInfo"));
        }
        return threadDump;
    }

    @Nullable
    private static StackTraceElement[] dumpThreadsToFile(@NotNull ThreadMXBean threadMXBean, @NotNull Writer f) {
        if (threadMXBean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "threadMXBean", "com/intellij/diagnostic/ThreadDumper", "dumpThreadsToFile"));
        }
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/intellij/diagnostic/ThreadDumper", "dumpThreadsToFile"));
        }
        StackTraceElement[] edtStack = null;
        boolean dumpSuccessful = false;
        try {
            ThreadInfo[] threads = ThreadDumper.sort(threadMXBean.dumpAllThreads(false, false));
            edtStack = ThreadDumper.dumpThreadInfos(threads, f);
            dumpSuccessful = true;
        }
        catch (Exception threads) {
            // empty catch block
        }
        if (!dumpSuccessful) {
            long[] threadIds = threadMXBean.getAllThreadIds();
            ThreadInfo[] threadInfo = ThreadDumper.sort(threadMXBean.getThreadInfo(threadIds, Integer.MAX_VALUE));
            edtStack = ThreadDumper.dumpThreadInfos(threadInfo, f);
        }
        return edtStack;
    }

    private static StackTraceElement[] dumpThreadInfos(@NotNull ThreadInfo[] threadInfo, @NotNull Writer f) {
        if (threadInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "threadInfo", "com/intellij/diagnostic/ThreadDumper", "dumpThreadInfos"));
        }
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/intellij/diagnostic/ThreadDumper", "dumpThreadInfos"));
        }
        StackTraceElement[] edtStack = null;
        for (ThreadInfo info : threadInfo) {
            if (info == null) continue;
            if (info.getThreadName().equals("AWT-EventQueue-1")) {
                edtStack = info.getStackTrace();
            }
            ThreadDumper.dumpThreadInfo(info, f);
        }
        return edtStack;
    }

    @NotNull
    private static ThreadInfo[] sort(@NotNull ThreadInfo[] threads) {
        if (threads == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "threads", "com/intellij/diagnostic/ThreadDumper", "sort"));
        }
        Arrays.sort(threads, new Comparator<ThreadInfo>(){

            @Override
            public int compare(ThreadInfo o1, ThreadInfo o2) {
                boolean r2;
                String t1 = o1.getThreadName();
                String t2 = o2.getThreadName();
                if (t1.startsWith("AWT-EventQueue")) {
                    return -1;
                }
                if (t2.startsWith("AWT-EventQueue")) {
                    return 1;
                }
                boolean r1 = o1.getThreadState() == Thread.State.RUNNABLE;
                boolean bl = r2 = o2.getThreadState() == Thread.State.RUNNABLE;
                if (r1 && !r2) {
                    return -1;
                }
                if (r2 && !r1) {
                    return 1;
                }
                return 0;
            }
        });
        if (threads == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagnostic/ThreadDumper", "sort"));
        }
        return threads;
    }

    private static void dumpThreadInfo(@NotNull ThreadInfo info, @NotNull Writer f) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/diagnostic/ThreadDumper", "dumpThreadInfo"));
        }
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/intellij/diagnostic/ThreadDumper", "dumpThreadInfo"));
        }
        ThreadDumper.dumpCallStack(info, f, info.getStackTrace());
    }

    private static void dumpCallStack(@NotNull ThreadInfo info, @NotNull Writer f, @NotNull StackTraceElement[] stackTraceElements) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/diagnostic/ThreadDumper", "dumpCallStack"));
        }
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/intellij/diagnostic/ThreadDumper", "dumpCallStack"));
        }
        if (stackTraceElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stackTraceElements", "com/intellij/diagnostic/ThreadDumper", "dumpCallStack"));
        }
        try {
            StringBuilder sb = new StringBuilder("\"").append(info.getThreadName()).append("\"");
            sb.append(" prio=0 tid=0x0 nid=0x0 ").append(ThreadDumper.getReadableState(info.getThreadState())).append("\n");
            sb.append("     java.lang.Thread.State: ").append((Object)info.getThreadState()).append("\n");
            if (info.getLockName() != null) {
                sb.append(" on ").append(info.getLockName());
            }
            if (info.getLockOwnerName() != null) {
                sb.append(" owned by \"").append(info.getLockOwnerName()).append("\" Id=").append(info.getLockOwnerId());
            }
            if (info.isSuspended()) {
                sb.append(" (suspended)");
            }
            if (info.isInNative()) {
                sb.append(" (in native)");
            }
            f.write(sb + "\n");
            ThreadDumper.printStackTrace(f, stackTraceElements);
            f.write("\n");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void printStackTrace(@NotNull Writer f, @NotNull StackTraceElement[] stackTraceElements) {
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/intellij/diagnostic/ThreadDumper", "printStackTrace"));
        }
        if (stackTraceElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stackTraceElements", "com/intellij/diagnostic/ThreadDumper", "printStackTrace"));
        }
        try {
            for (StackTraceElement element : stackTraceElements) {
                f.write("\tat " + element.toString() + "\n");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getReadableState(@NotNull Thread.State state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/diagnostic/ThreadDumper", "getReadableState"));
        }
        switch (state) {
            case BLOCKED: {
                return "blocked";
            }
            case TIMED_WAITING: 
            case WAITING: {
                return "waiting on condition";
            }
            case RUNNABLE: {
                return "runnable";
            }
            case NEW: {
                return "new";
            }
            case TERMINATED: {
                return "terminated";
            }
        }
        return null;
    }
}

