/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.cloudbees.cloud;

import com.intellij.javaee.cloudbees.agent.cloud.CBCloudAgent;
import com.intellij.javaee.cloudbees.agent.cloud.CBCloudAgentDeploymentConfig;
import com.intellij.javaee.cloudbees.cloud.CBDeploymentConfiguration;
import com.intellij.javaee.oss.admin.ModuleTypeWrapper;
import com.intellij.javaee.oss.util.ModuleTypeUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.remoteServer.agent.util.CloudAgentApplication;
import com.intellij.remoteServer.agent.util.CloudAgentDeployment;
import com.intellij.remoteServer.agent.util.CloudAgentDeploymentCallback;
import com.intellij.remoteServer.agent.util.CloudAgentLoggingHandler;
import com.intellij.remoteServer.configuration.deployment.ArtifactDeploymentSource;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentRuntime;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import com.intellij.remoteServer.runtime.log.LoggingHandler;
import com.intellij.remoteServer.util.CloudApplicationRuntimeBase;
import com.intellij.remoteServer.util.CloudLoggingHandlerImpl;
import java.io.File;

public class CBDeploymentRuntime
extends CloudApplicationRuntimeBase {
    private final String myApplicationUrl;
    private final DeploymentLogManager myLogManager;
    private final CloudAgentDeployment myDeployment;

    public CBDeploymentRuntime(ServerTaskExecutor tasksExecutor, CBCloudAgent agent, final String deploymentName, String applicationUrl, final DeploymentTask<CBDeploymentConfiguration> task, DeploymentLogManager logManager) {
        super(tasksExecutor, deploymentName);
        this.myApplicationUrl = applicationUrl;
        this.myLogManager = logManager;
        final DeploymentSource source = task.getSource();
        this.myDeployment = agent.createDeployment(new CBCloudAgentDeploymentConfig(){

            public String getDeploymentName() {
                return deploymentName;
            }

            public File getFile() {
                return source.getFile();
            }

            @Override
            public String getContainerType() {
                return ((CBDeploymentConfiguration)task.getConfiguration()).getContainerType().getId();
            }

            @Override
            public String getPackageType() {
                ModuleTypeWrapper moduleType = null;
                if (source instanceof ArtifactDeploymentSource) {
                    moduleType = ModuleTypeUtil.getModuleType((Artifact)((ArtifactDeploymentSource)source).getArtifact());
                }
                if (moduleType == null) {
                    moduleType = ModuleTypeWrapper.WAR;
                }
                return moduleType.getName();
            }
        }, (CloudAgentLoggingHandler)new CloudLoggingHandlerImpl(logManager));
    }

    protected CloudAgentApplication getApplication() {
        return this.myDeployment;
    }

    public void deploy(final ServerRuntimeInstance.DeploymentOperationCallback callback) {
        this.myDeployment.deploy(new CloudAgentDeploymentCallback(){

            public void succeeded() {
                LoggingHandler loggingHandler = CBDeploymentRuntime.this.myLogManager.getMainLoggingHandler();
                loggingHandler.print("Application is available at ");
                loggingHandler.printHyperlink(CBDeploymentRuntime.this.myApplicationUrl);
                loggingHandler.print("\n");
                callback.succeeded((DeploymentRuntime)CBDeploymentRuntime.this);
            }

            public void errorOccurred(String errorMessage) {
                callback.errorOccurred(errorMessage);
            }
        });
    }
}

