/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.cloudbees;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.javaee.cloudbees.CBLocalModel;
import com.intellij.javaee.cloudbees.cloud.CBConnector;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.run.configuration.JavaCommandLineStartupPolicy;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.remoteServer.runtime.clientLibrary.ClientLibraryManager;
import com.intellij.util.PathsList;
import java.io.File;
import java.io.IOException;
import java.util.Collection;

public class CBStartupPolicy
implements JavaCommandLineStartupPolicy {
    public JavaParameters createCommandLine(CommonModel commonModel) throws ExecutionException {
        JavaParameters result = new JavaParameters();
        try {
            File baseTempDir = FileUtil.createTempDirectory((String)"tomcat", (String)"base");
            baseTempDir.deleteOnExit();
            result.setWorkingDirectory(baseTempDir);
            if (!new File(baseTempDir, "webapps").mkdir()) {
                throw new ExecutionException("Can't create webapps directory");
            }
            result.setMainClass("com.staxnet.appserver.StaxSdkAppServer");
            CBLocalModel serverModel = (CBLocalModel)commonModel.getServerModel();
            ParametersList vmParams = result.getVMParametersList();
            vmParams.defineProperty("com.sun.management.jmxremote", "");
            vmParams.defineProperty("com.sun.management.jmxremote.port", String.valueOf(serverModel.JNDI_PORT));
            vmParams.defineProperty("com.sun.management.jmxremote.authenticate", "false");
            vmParams.defineProperty("com.sun.management.jmxremote.ssl", "false");
            PathsList classPath = result.getClassPath();
            for (File library : ClientLibraryManager.getInstance().getLibraries(CBConnector.LIBRARY_DESCRIPTION)) {
                classPath.add(library);
            }
            ParametersList programParams = result.getProgramParametersList();
            programParams.add("-dir");
            programParams.add(baseTempDir.getAbsolutePath());
            programParams.add("-web");
            Collection deploymentModels = commonModel.getDeploymentModels();
            if (deploymentModels.isEmpty()) {
                throw new ExecutionException("No deployments specified");
            }
            DeploymentModel deploymentModel = (DeploymentModel)deploymentModels.iterator().next();
            String deploymentPath = deploymentModel.getDeploymentSource().getFilePath();
            if (deploymentPath == null) {
                throw new ExecutionException("Can't acquire deployment path");
            }
            programParams.add(deploymentPath);
            programParams.add("-port");
            programParams.add(String.valueOf(serverModel.HTTP_PORT_X));
        }
        catch (IOException e) {
            throw new ExecutionException("Can't configure temporary base directory", (Throwable)e);
        }
        return result;
    }
}

