/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.google.common.collect.ImmutableList;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class JavaScriptFileType
extends LanguageFileType {
    private static final NotNullLazyValue<List<FileType>> ourFileTypesCompilableToJavaScript = new NotNullLazyValue<List<FileType>>(){

        @NotNull
        protected List<FileType> compute() {
            ArrayList fileTypes = ContainerUtil.newArrayList();
            for (FileType type : FileTypeRegistry.getInstance().getRegisteredFileTypes()) {
                Language language;
                if (type.getDefaultExtension().equals("as") || !(type instanceof LanguageFileType) || !(language = ((LanguageFileType)type).getLanguage()).isKindOf((Language)JavascriptLanguage.INSTANCE)) continue;
                fileTypes.add(type);
            }
            ImmutableList immutableList = ImmutableList.copyOf((Collection)fileTypes);
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/JavaScriptFileType$1", "compute"));
            }
            return immutableList;
        }
    };
    public static final JavaScriptFileType INSTANCE = new JavaScriptFileType();

    public JavaScriptFileType() {
        super((Language)JavascriptLanguage.INSTANCE);
    }

    @NotNull
    public String getName() {
        if ("JavaScript" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/JavaScriptFileType", "getName"));
        }
        return "JavaScript";
    }

    @NotNull
    public String getDescription() {
        String string = JSBundle.message("javascript.filetype.description", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/JavaScriptFileType", "getDescription"));
        }
        return string;
    }

    @NotNull
    public String getDefaultExtension() {
        if ("js" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/JavaScriptFileType", "getDefaultExtension"));
        }
        return "js";
    }

    public Icon getIcon() {
        return AllIcons.FileTypes.JavaScript;
    }

    @NotNull
    public static List<FileType> getFileTypesCompilableToJavaScript() {
        List list = (List)ourFileTypesCompilableToJavaScript.getValue();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/JavaScriptFileType", "getFileTypesCompilableToJavaScript"));
        }
        return list;
    }
}

