/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.flex.model.bc.impl;

import com.intellij.flex.model.bc.JpsFlexCompilerOptions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.ex.JpsElementBase;

public class JpsFlexCompilerOptionsImpl
extends JpsElementBase<JpsFlexCompilerOptionsImpl>
implements JpsFlexCompilerOptions {
    @NotNull
    private final Map<String, String> myOptions = new THashMap();
    @NotNull
    private JpsFlexCompilerOptions.ResourceFilesMode myResourceFilesMode = JpsFlexCompilerOptions.ResourceFilesMode.All;
    @NotNull
    private String myFilesToIncludeInSWC = "";
    @NotNull
    private String myAdditionalConfigFilePath = "";
    @NotNull
    private String myAdditionalOptions = "";

    JpsFlexCompilerOptionsImpl() {
    }

    private JpsFlexCompilerOptionsImpl(JpsFlexCompilerOptionsImpl original) {
        this.myOptions.clear();
        this.myOptions.putAll(original.myOptions);
        this.myResourceFilesMode = original.myResourceFilesMode;
        this.myFilesToIncludeInSWC = original.myFilesToIncludeInSWC;
        this.myAdditionalConfigFilePath = original.myAdditionalConfigFilePath;
        this.myAdditionalOptions = original.myAdditionalOptions;
    }

    @NotNull
    public JpsFlexCompilerOptionsImpl createCopy() {
        JpsFlexCompilerOptionsImpl jpsFlexCompilerOptionsImpl = new JpsFlexCompilerOptionsImpl(this);
        if (jpsFlexCompilerOptionsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/model/bc/impl/JpsFlexCompilerOptionsImpl", "createCopy"));
        }
        return jpsFlexCompilerOptionsImpl;
    }

    public void applyChanges(@NotNull JpsFlexCompilerOptionsImpl modified) {
        if (modified == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modified", "com/intellij/flex/model/bc/impl/JpsFlexCompilerOptionsImpl", "applyChanges"));
        }
        this.myOptions.clear();
        this.myOptions.putAll(modified.myOptions);
        this.myResourceFilesMode = modified.myResourceFilesMode;
        this.myFilesToIncludeInSWC = modified.myFilesToIncludeInSWC;
        this.myAdditionalConfigFilePath = modified.myAdditionalConfigFilePath;
        this.myAdditionalOptions = modified.myAdditionalOptions;
    }

    @Override
    @Nullable
    public String getOption(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/flex/model/bc/impl/JpsFlexCompilerOptionsImpl", "getOption"));
        }
        return this.myOptions.get(name);
    }

    @Override
    @NotNull
    public Map<String, String> getAllOptions() {
        Map<String, String> map = Collections.unmodifiableMap(this.myOptions);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/model/bc/impl/JpsFlexCompilerOptionsImpl", "getAllOptions"));
        }
        return map;
    }

    @Override
    @NotNull
    public JpsFlexCompilerOptions.ResourceFilesMode getResourceFilesMode() {
        JpsFlexCompilerOptions.ResourceFilesMode resourceFilesMode = this.myResourceFilesMode;
        if (resourceFilesMode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/model/bc/impl/JpsFlexCompilerOptionsImpl", "getResourceFilesMode"));
        }
        return resourceFilesMode;
    }

    @Override
    public void setResourceFilesMode(@NotNull JpsFlexCompilerOptions.ResourceFilesMode resourceFilesMode) {
        if (resourceFilesMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceFilesMode", "com/intellij/flex/model/bc/impl/JpsFlexCompilerOptionsImpl", "setResourceFilesMode"));
        }
        this.myResourceFilesMode = resourceFilesMode;
    }

    @Override
    @NotNull
    public Collection<String> getFilesToIncludeInSWC() {
        if (this.myFilesToIncludeInSWC.isEmpty()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/model/bc/impl/JpsFlexCompilerOptionsImpl", "getFilesToIncludeInSWC"));
            }
            return list;
        }
        List list = StringUtil.split((String)this.myFilesToIncludeInSWC, (String)"\n");
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/model/bc/impl/JpsFlexCompilerOptionsImpl", "getFilesToIncludeInSWC"));
        }
        return list;
    }

    @Override
    @NotNull
    public String getAdditionalConfigFilePath() {
        String string = this.myAdditionalConfigFilePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/model/bc/impl/JpsFlexCompilerOptionsImpl", "getAdditionalConfigFilePath"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getAdditionalOptions() {
        String string = this.myAdditionalOptions;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/model/bc/impl/JpsFlexCompilerOptionsImpl", "getAdditionalOptions"));
        }
        return string;
    }

    @Override
    public void setAdditionalOptions(@NotNull String additionalOptions) {
        if (additionalOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalOptions", "com/intellij/flex/model/bc/impl/JpsFlexCompilerOptionsImpl", "setAdditionalOptions"));
        }
        this.myAdditionalOptions = additionalOptions;
    }

    public State getState() {
        State state = new State();
        for (Map.Entry<String, String> entry : this.myOptions.entrySet()) {
            state.options.put(entry.getKey(), entry.getValue());
        }
        state.resourceFilesMode = this.myResourceFilesMode;
        state.filesToIncludeInSWC = this.myFilesToIncludeInSWC;
        state.additionalConfigFilePath = this.myAdditionalConfigFilePath;
        state.additionalOptions = this.myAdditionalOptions;
        return state;
    }

    public void loadState(State state) {
        assert (this.myOptions.isEmpty());
        for (Map.Entry<String, String> entry : state.options.entrySet()) {
            this.myOptions.put(entry.getKey(), entry.getValue());
        }
        this.myResourceFilesMode = state.resourceFilesMode;
        this.myFilesToIncludeInSWC = state.filesToIncludeInSWC;
        this.myAdditionalConfigFilePath = state.additionalConfigFilePath;
        this.myAdditionalOptions = state.additionalOptions;
    }

    @Tag(value="compiler-options")
    public static class State {
        @Property(surroundWithTag=false)
        @MapAnnotation(surroundKeyWithTag=false, surroundValueWithTag=false)
        public Map<String, String> options = new THashMap();
        public JpsFlexCompilerOptions.ResourceFilesMode resourceFilesMode = JpsFlexCompilerOptions.ResourceFilesMode.All;
        public String filesToIncludeInSWC = "";
        public String additionalConfigFilePath = "";
        public String additionalOptions = "";
    }
}

