/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.flex.model.bc.impl;

import com.intellij.flex.FlexCommonUtils;
import com.intellij.flex.model.bc.BuildConfigurationNature;
import com.intellij.flex.model.bc.InfoFromConfigFile;
import com.intellij.flex.model.bc.JpsAirDesktopPackagingOptions;
import com.intellij.flex.model.bc.JpsAndroidPackagingOptions;
import com.intellij.flex.model.bc.JpsFlexBCReference;
import com.intellij.flex.model.bc.JpsFlexBuildConfiguration;
import com.intellij.flex.model.bc.JpsFlexBuildConfigurationManager;
import com.intellij.flex.model.bc.JpsFlexCompilerOptions;
import com.intellij.flex.model.bc.JpsFlexDependencies;
import com.intellij.flex.model.bc.JpsIosPackagingOptions;
import com.intellij.flex.model.bc.OutputType;
import com.intellij.flex.model.bc.TargetPlatform;
import com.intellij.flex.model.bc.impl.JpsAirDesktopPackagingOptionsImpl;
import com.intellij.flex.model.bc.impl.JpsAndroidPackagingOptionsImpl;
import com.intellij.flex.model.bc.impl.JpsFlexBCReferenceImpl;
import com.intellij.flex.model.bc.impl.JpsFlexBCState;
import com.intellij.flex.model.bc.impl.JpsFlexCompilerOptionsImpl;
import com.intellij.flex.model.bc.impl.JpsFlexCompilerOptionsRole;
import com.intellij.flex.model.bc.impl.JpsFlexDependenciesImpl;
import com.intellij.flex.model.bc.impl.JpsIosPackagingOptionsImpl;
import com.intellij.flex.model.sdk.JpsFlexmojosSdkType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.model.ex.JpsElementCollectionRole;
import org.jetbrains.jps.model.ex.JpsNamedCompositeElementBase;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.module.JpsTypedModule;

class JpsFlexBuildConfigurationImpl
extends JpsNamedCompositeElementBase<JpsFlexBuildConfigurationImpl>
implements JpsFlexBuildConfiguration {
    private static final JpsElementChildRoleBase<JpsFlexBuildConfiguration> ROLE = JpsElementChildRoleBase.create((String)"flex build configuration");
    static final JpsElementCollectionRole<JpsFlexBuildConfiguration> COLLECTION_ROLE = JpsElementCollectionRole.create(ROLE);
    @NotNull
    private TargetPlatform myTargetPlatform;
    private boolean myPureAs;
    @NotNull
    private OutputType myOutputType;
    @NotNull
    private String myOptimizeFor;
    @NotNull
    private String myMainClass;
    @NotNull
    private String myOutputFileName;
    @NotNull
    private String myOutputFolder;
    private boolean myUseHtmlWrapper;
    @NotNull
    private String myWrapperTemplatePath;
    @NotNull
    private String myRLMs;
    @NotNull
    private String myCssFilesToCompile;
    private boolean mySkipCompile;
    private boolean myTempBCForCompilation;

    JpsFlexBuildConfigurationImpl(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/flex/model/bc/impl/JpsFlexBuildConfigurationImpl", "<init>"));
        }
        super(name);
        this.myTargetPlatform = BuildConfigurationNature.DEFAULT.targetPlatform;
        this.myPureAs = BuildConfigurationNature.DEFAULT.pureAS;
        this.myOutputType = BuildConfigurationNature.DEFAULT.outputType;
        this.myOptimizeFor = "";
        this.myMainClass = "";
        this.myOutputFileName = "";
        this.myOutputFolder = "";
        this.myUseHtmlWrapper = false;
        this.myWrapperTemplatePath = "";
        this.myRLMs = "";
        this.myCssFilesToCompile = "";
        this.mySkipCompile = false;
        this.myTempBCForCompilation = false;
        this.myContainer.setChild((JpsElementChildRole)JpsFlexDependenciesImpl.ROLE);
        this.myContainer.setChild((JpsElementChildRole)JpsFlexCompilerOptionsRole.INSTANCE);
        this.myContainer.setChild((JpsElementChildRole)JpsAirDesktopPackagingOptionsImpl.ROLE);
        this.myContainer.setChild((JpsElementChildRole)JpsAndroidPackagingOptionsImpl.ROLE);
        this.myContainer.setChild((JpsElementChildRole)JpsIosPackagingOptionsImpl.ROLE);
    }

    private JpsFlexBuildConfigurationImpl(JpsFlexBuildConfigurationImpl original) {
        super((JpsNamedCompositeElementBase)original);
        this.myTargetPlatform = BuildConfigurationNature.DEFAULT.targetPlatform;
        this.myPureAs = BuildConfigurationNature.DEFAULT.pureAS;
        this.myOutputType = BuildConfigurationNature.DEFAULT.outputType;
        this.myOptimizeFor = "";
        this.myMainClass = "";
        this.myOutputFileName = "";
        this.myOutputFolder = "";
        this.myUseHtmlWrapper = false;
        this.myWrapperTemplatePath = "";
        this.myRLMs = "";
        this.myCssFilesToCompile = "";
        this.mySkipCompile = false;
        this.myTempBCForCompilation = false;
        this.myTargetPlatform = original.myTargetPlatform;
        this.myPureAs = original.myPureAs;
        this.myOutputType = original.myOutputType;
        this.myOptimizeFor = original.myOptimizeFor;
        this.myMainClass = original.myMainClass;
        this.myOutputFileName = original.myOutputFileName;
        this.myOutputFolder = original.myOutputFolder;
        this.myUseHtmlWrapper = original.myUseHtmlWrapper;
        this.myWrapperTemplatePath = original.myWrapperTemplatePath;
        this.myRLMs = original.myRLMs;
        this.myCssFilesToCompile = original.myCssFilesToCompile;
        this.mySkipCompile = original.mySkipCompile;
        this.myTempBCForCompilation = original.myTempBCForCompilation;
    }

    @NotNull
    public JpsFlexBuildConfigurationImpl createCopy() {
        JpsFlexBuildConfigurationImpl jpsFlexBuildConfigurationImpl = new JpsFlexBuildConfigurationImpl(this);
        if (jpsFlexBuildConfigurationImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/model/bc/impl/JpsFlexBuildConfigurationImpl", "createCopy"));
        }
        return jpsFlexBuildConfigurationImpl;
    }

    public void applyChanges(@NotNull JpsFlexBuildConfigurationImpl modified) {
        if (modified == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modified", "com/intellij/flex/model/bc/impl/JpsFlexBuildConfigurationImpl", "applyChanges"));
        }
        super.applyChanges((JpsNamedCompositeElementBase)modified);
        this.myTargetPlatform = modified.myTargetPlatform;
        this.myPureAs = modified.myPureAs;
        this.myOutputType = modified.myOutputType;
        this.myOptimizeFor = modified.myOptimizeFor;
        this.myMainClass = modified.myMainClass;
        this.myOutputFileName = modified.myOutputFileName;
        this.myOutputFolder = modified.myOutputFolder;
        this.myUseHtmlWrapper = modified.myUseHtmlWrapper;
        this.myWrapperTemplatePath = modified.myWrapperTemplatePath;
        this.myRLMs = modified.myRLMs;
        this.myCssFilesToCompile = modified.myCssFilesToCompile;
        this.mySkipCompile = modified.mySkipCompile;
        this.myTempBCForCompilation = modified.myTempBCForCompilation;
    }

    @Override
    public JpsTypedModule<JpsFlexBuildConfigurationManager> getModule() {
        return (JpsTypedModule)this.myParent.getParent().getParent();
    }

    @NotNull
    public JpsFlexBCReference createReference() {
        JpsFlexBCReferenceImpl jpsFlexBCReferenceImpl = new JpsFlexBCReferenceImpl(this.getName(), this.getModule().createReference());
        if (jpsFlexBCReferenceImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/model/bc/impl/JpsFlexBuildConfigurationImpl", "createReference"));
        }
        return jpsFlexBCReferenceImpl;
    }

    @Override
    @NotNull
    public TargetPlatform getTargetPlatform() {
        TargetPlatform targetPlatform = this.myTargetPlatform;
        if (targetPlatform == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/model/bc/impl/JpsFlexBuildConfigurationImpl", "getTargetPlatform"));
        }
        return targetPlatform;
    }

    @Override
    public boolean isPureAs() {
        return this.myPureAs;
    }

    @Override
    @NotNull
    public OutputType getOutputType() {
        OutputType outputType = this.myOutputType;
        if (outputType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/model/bc/impl/JpsFlexBuildConfigurationImpl", "getOutputType"));
        }
        return outputType;
    }

    @Override
    public void setOutputType(@NotNull OutputType outputType) {
        if (outputType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputType", "com/intellij/flex/model/bc/impl/JpsFlexBuildConfigurationImpl", "setOutputType"));
        }
        this.myOutputType = outputType;
    }

    @Override
    @NotNull
    public String getOptimizeFor() {
        String string = this.myOptimizeFor;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/model/bc/impl/JpsFlexBuildConfigurationImpl", "getOptimizeFor"));
        }
        return string;
    }

    @Override
    public void setOptimizeFor(@NotNull String optimizeFor) {
        if (optimizeFor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optimizeFor", "com/intellij/flex/model/bc/impl/JpsFlexBuildConfigurationImpl", "setOptimizeFor"));
        }
        this.myOptimizeFor = optimizeFor;
    }

    @Override
    @NotNull
    public String getMainClass() {
        String string = this.myMainClass;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/model/bc/impl/JpsFlexBuildConfigurationImpl", "getMainClass"));
        }
        return string;
    }

    @Override
    public void setMainClass(@NotNull String mainClass) {
        if (mainClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainClass", "com/intellij/flex/model/bc/impl/JpsFlexBuildConfigurationImpl", "setMainClass"));
        }
        this.myMainClass = mainClass;
    }

    @Override
    @NotNull
    public String getOutputFileName() {
        String string = this.myOutputFileName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/model/bc/impl/JpsFlexBuildConfigurationImpl", "getOutputFileName"));
        }
        return string;
    }

    @Override
    public void setOutputFileName(@NotNull String outputFileName) {
        if (outputFileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputFileName", "com/intellij/flex/model/bc/impl/JpsFlexBuildConfigurationImpl", "setOutputFileName"));
        }
        this.myOutputFileName = outputFileName;
    }

    @Override
    @NotNull
    public String getOutputFolder() {
        String string = this.myOutputFolder;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/model/bc/impl/JpsFlexBuildConfigurationImpl", "getOutputFolder"));
        }
        return string;
    }

    @Override
    public void setOutputFolder(@NotNull String outputFolder) {
        if (outputFolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputFolder", "com/intellij/flex/model/bc/impl/JpsFlexBuildConfigurationImpl", "setOutputFolder"));
        }
        this.myOutputFolder = outputFolder;
    }

    @Override
    public boolean isUseHtmlWrapper() {
        return this.myUseHtmlWrapper;
    }

    @Override
    public void setUseHtmlWrapper(boolean useHtmlWrapper) {
        this.myUseHtmlWrapper = useHtmlWrapper;
    }

    @Override
    @NotNull
    public String getWrapperTemplatePath() {
        String string = this.myWrapperTemplatePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/model/bc/impl/JpsFlexBuildConfigurationImpl", "getWrapperTemplatePath"));
        }
        return string;
    }

    @Override
    @NotNull
    public Collection<JpsFlexBuildConfiguration.RLMInfo> getRLMs() {
        if (this.myRLMs.isEmpty()) {
            List<JpsFlexBuildConfiguration.RLMInfo> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/model/bc/impl/JpsFlexBuildConfigurationImpl", "getRLMs"));
            }
            return list;
        }
        List entries = StringUtil.split((String)this.myRLMs, (String)"\n");
        ArrayList<JpsFlexBuildConfiguration.RLMInfo> result = new ArrayList<JpsFlexBuildConfiguration.RLMInfo>(entries.size());
        for (String entry : entries) {
            List parts = StringUtil.split((String)entry, (String)"\t", (boolean)true, (boolean)false);
            assert (parts.size() == 3) : entry;
            result.add(new JpsFlexBuildConfiguration.RLMInfo((String)parts.get(0), (String)parts.get(1), Boolean.valueOf((String)parts.get(2))));
        }
        ArrayList<JpsFlexBuildConfiguration.RLMInfo> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/model/bc/impl/JpsFlexBuildConfigurationImpl", "getRLMs"));
        }
        return arrayList;
    }

    @Override
    public void setRLMs(@NotNull Collection<JpsFlexBuildConfiguration.RLMInfo> rlms) {
        if (rlms == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rlms", "com/intellij/flex/model/bc/impl/JpsFlexBuildConfigurationImpl", "setRLMs"));
        }
        if (rlms.isEmpty()) {
            this.myRLMs = "";
        }
        this.myRLMs = StringUtil.join(rlms, (Function)new Function<JpsFlexBuildConfiguration.RLMInfo, String>(){

            public String fun(JpsFlexBuildConfiguration.RLMInfo info) {
                return info.MAIN_CLASS + "\t" + info.OUTPUT_FILE + "\t" + info.OPTIMIZE;
            }
        }, (String)"\n");
    }

    @Override
    @NotNull
    public Collection<String> getCssFilesToCompile() {
        if (this.myCssFilesToCompile.isEmpty()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/model/bc/impl/JpsFlexBuildConfigurationImpl", "getCssFilesToCompile"));
            }
            return list;
        }
        List list = StringUtil.split((String)this.myCssFilesToCompile, (String)"\n");
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/model/bc/impl/JpsFlexBuildConfigurationImpl", "getCssFilesToCompile"));
        }
        return list;
    }

    @Override
    public void setCssFilesToCompile(@NotNull Collection<String> cssFilesToCompile) {
        if (cssFilesToCompile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cssFilesToCompile", "com/intellij/flex/model/bc/impl/JpsFlexBuildConfigurationImpl", "setCssFilesToCompile"));
        }
        this.myCssFilesToCompile = cssFilesToCompile.isEmpty() ? "" : StringUtil.join(cssFilesToCompile, (String)"\n");
    }

    @Override
    public boolean isSkipCompile() {
        return this.mySkipCompile;
    }

    @Override
    public void setSkipCompile(boolean skipCompile) {
        this.mySkipCompile = skipCompile;
    }

    @Override
    @NotNull
    public JpsFlexDependencies getDependencies() {
        JpsFlexDependencies jpsFlexDependencies = (JpsFlexDependencies)this.myContainer.getChild((JpsElementChildRole)JpsFlexDependenciesImpl.ROLE);
        if (jpsFlexDependencies == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/model/bc/impl/JpsFlexBuildConfigurationImpl", "getDependencies"));
        }
        return jpsFlexDependencies;
    }

    @Override
    @NotNull
    public JpsFlexCompilerOptions getCompilerOptions() {
        JpsFlexCompilerOptions jpsFlexCompilerOptions = (JpsFlexCompilerOptions)this.myContainer.getChild((JpsElementChildRole)JpsFlexCompilerOptionsRole.INSTANCE);
        if (jpsFlexCompilerOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/model/bc/impl/JpsFlexBuildConfigurationImpl", "getCompilerOptions"));
        }
        return jpsFlexCompilerOptions;
    }

    @Override
    @NotNull
    public JpsAirDesktopPackagingOptions getAirDesktopPackagingOptions() {
        JpsAirDesktopPackagingOptions jpsAirDesktopPackagingOptions = (JpsAirDesktopPackagingOptions)this.myContainer.getChild((JpsElementChildRole)JpsAirDesktopPackagingOptionsImpl.ROLE);
        if (jpsAirDesktopPackagingOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/model/bc/impl/JpsFlexBuildConfigurationImpl", "getAirDesktopPackagingOptions"));
        }
        return jpsAirDesktopPackagingOptions;
    }

    @Override
    @NotNull
    public JpsAndroidPackagingOptions getAndroidPackagingOptions() {
        JpsAndroidPackagingOptions jpsAndroidPackagingOptions = (JpsAndroidPackagingOptions)this.myContainer.getChild((JpsElementChildRole)JpsAndroidPackagingOptionsImpl.ROLE);
        if (jpsAndroidPackagingOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/model/bc/impl/JpsFlexBuildConfigurationImpl", "getAndroidPackagingOptions"));
        }
        return jpsAndroidPackagingOptions;
    }

    @Override
    @NotNull
    public JpsIosPackagingOptions getIosPackagingOptions() {
        JpsIosPackagingOptions jpsIosPackagingOptions = (JpsIosPackagingOptions)this.myContainer.getChild((JpsElementChildRole)JpsIosPackagingOptionsImpl.ROLE);
        if (jpsIosPackagingOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/model/bc/impl/JpsFlexBuildConfigurationImpl", "getIosPackagingOptions"));
        }
        return jpsIosPackagingOptions;
    }

    @Override
    public Icon getIcon() {
        return this.getNature().getIcon();
    }

    @Override
    public String getShortText() {
        return this.getName();
    }

    @Override
    public String getDescription() {
        return this.myOutputType.getShortText();
    }

    @Override
    public String getActualOutputFilePath() {
        InfoFromConfigFile info = InfoFromConfigFile.getInfoFromConfigFile(this.getCompilerOptions().getAdditionalConfigFilePath());
        String outputFolderPath = FlexCommonUtils.isFlexUnitBC(this) ? this.myOutputFolder : StringUtil.notNullize((String)info.getOutputFolderPath(), (String)this.myOutputFolder);
        String outputFileName = this.myTempBCForCompilation ? this.myOutputFileName : StringUtil.notNullize((String)info.getOutputFileName(), (String)this.myOutputFileName);
        return outputFolderPath + (outputFolderPath.isEmpty() ? "" : "/") + outputFileName;
    }

    @Override
    public BuildConfigurationNature getNature() {
        return new BuildConfigurationNature(this.myTargetPlatform, this.myPureAs, this.myOutputType);
    }

    @Override
    @Nullable
    public JpsSdk<?> getSdk() {
        return this.getDependencies().getSdk();
    }

    @Override
    public boolean isTempBCForCompilation() {
        return this.myTempBCForCompilation;
    }

    void setTempBCForCompilation(boolean tempBCForCompilation) {
        this.myTempBCForCompilation = tempBCForCompilation;
    }

    public String toString() {
        return this.getName() + ": " + this.getNature().toString();
    }

    @Override
    public String getStatisticsEntry() {
        StringBuilder s = new StringBuilder();
        switch (this.myTargetPlatform) {
            case Web: {
                s.append("Web");
                break;
            }
            case Desktop: {
                s.append("Desktop");
                break;
            }
            case Mobile: {
                s.append("Mobile");
                if (this.getAndroidPackagingOptions().isEnabled() && this.getIosPackagingOptions().isEnabled()) {
                    s.append("(a+i)");
                    break;
                }
                if (this.getAndroidPackagingOptions().isEnabled()) {
                    s.append("(a)");
                    break;
                }
                if (!this.getIosPackagingOptions().isEnabled()) break;
                s.append("(i)");
                break;
            }
            default: {
                assert (false) : this.myTargetPlatform;
                break;
            }
        }
        s.append(" ");
        s.append(this.myPureAs ? "AS" : "Flex");
        s.append(" ");
        switch (this.myOutputType) {
            case Application: {
                s.append("app");
                break;
            }
            case Library: {
                s.append("lib");
                break;
            }
            case RuntimeLoadedModule: {
                s.append("rlm");
                break;
            }
            default: {
                assert (false) : this.myOutputType;
                break;
            }
        }
        JpsSdk<?> sdk = this.getSdk();
        if (sdk != null && sdk.getSdkType() == JpsFlexmojosSdkType.INSTANCE) {
            s.append(" (mvn)");
        }
        return s.toString();
    }

    JpsFlexBCState getState() {
        JpsFlexBCState state = new JpsFlexBCState();
        state.DEPENDENCIES = ((JpsFlexDependenciesImpl)this.getContainer().getChild((JpsElementChildRole)JpsFlexDependenciesImpl.ROLE)).getState();
        state.COMPILER_OPTIONS = ((JpsFlexCompilerOptionsImpl)this.getContainer().getChild((JpsElementChildRole)JpsFlexCompilerOptionsRole.INSTANCE)).getState();
        state.AIR_DESKTOP_PACKAGING_OPTIONS = ((JpsAirDesktopPackagingOptionsImpl)this.getContainer().getChild((JpsElementChildRole)JpsAirDesktopPackagingOptionsImpl.ROLE)).getState();
        state.ANDROID_PACKAGING_OPTIONS = ((JpsAndroidPackagingOptionsImpl)this.getContainer().getChild((JpsElementChildRole)JpsAndroidPackagingOptionsImpl.ROLE)).getState();
        state.IOS_PACKAGING_OPTIONS = ((JpsIosPackagingOptionsImpl)this.getContainer().getChild((JpsElementChildRole)JpsIosPackagingOptionsImpl.ROLE)).getState();
        state.NAME = this.getName();
        state.TARGET_PLATFORM = this.myTargetPlatform;
        state.PURE_ACTION_SCRIPT = this.myPureAs;
        state.OUTPUT_TYPE = this.myOutputType;
        state.MAIN_CLASS = this.myMainClass;
        state.OUTPUT_FILE_NAME = this.myOutputFileName;
        state.OUTPUT_FOLDER = this.myOutputFolder;
        state.USE_HTML_WRAPPER = this.myUseHtmlWrapper;
        state.WRAPPER_TEMPLATE_PATH = this.myWrapperTemplatePath;
        state.RLMS = this.myRLMs;
        state.CSS_FILES_TO_COMPILE = this.myCssFilesToCompile;
        state.SKIP_COMPILE = this.mySkipCompile;
        return state;
    }

    void loadState(JpsFlexBCState state) {
        ((JpsFlexDependenciesImpl)this.getContainer().getChild((JpsElementChildRole)JpsFlexDependenciesImpl.ROLE)).loadState(state.DEPENDENCIES);
        ((JpsFlexCompilerOptionsImpl)this.getContainer().getChild((JpsElementChildRole)JpsFlexCompilerOptionsRole.INSTANCE)).loadState(state.COMPILER_OPTIONS);
        ((JpsAirDesktopPackagingOptionsImpl)this.getContainer().getChild((JpsElementChildRole)JpsAirDesktopPackagingOptionsImpl.ROLE)).loadState(state.AIR_DESKTOP_PACKAGING_OPTIONS);
        ((JpsAndroidPackagingOptionsImpl)this.getContainer().getChild((JpsElementChildRole)JpsAndroidPackagingOptionsImpl.ROLE)).loadState(state.ANDROID_PACKAGING_OPTIONS);
        ((JpsIosPackagingOptionsImpl)this.getContainer().getChild((JpsElementChildRole)JpsIosPackagingOptionsImpl.ROLE)).loadState(state.IOS_PACKAGING_OPTIONS);
        this.myTargetPlatform = state.TARGET_PLATFORM;
        this.myPureAs = state.PURE_ACTION_SCRIPT;
        this.myOutputType = state.OUTPUT_TYPE;
        this.myMainClass = state.MAIN_CLASS;
        this.myOutputFileName = state.OUTPUT_FILE_NAME;
        this.myOutputFolder = state.OUTPUT_FOLDER;
        this.myUseHtmlWrapper = state.USE_HTML_WRAPPER;
        this.myWrapperTemplatePath = state.WRAPPER_TEMPLATE_PATH;
        this.myRLMs = state.RLMS;
        this.myCssFilesToCompile = state.CSS_FILES_TO_COMPILE;
        this.mySkipCompile = state.SKIP_COMPILE;
    }
}

