/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.flex.build;

import com.intellij.flex.FlexCommonUtils;
import com.intellij.flex.build.FlexBuildTarget;
import com.intellij.flex.model.bc.BuildConfigurationNature;
import com.intellij.flex.model.bc.JpsFlexBuildConfiguration;
import com.intellij.flex.model.bc.JpsFlexBuildConfigurationManager;
import com.intellij.flex.model.module.JpsFlexModuleType;
import com.intellij.flex.model.run.JpsFlashRunConfigurationType;
import com.intellij.flex.model.run.JpsFlexUnitRunConfigurationType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildTargetLoader;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.module.JpsModuleType;
import org.jetbrains.jps.model.module.JpsTypedModule;
import org.jetbrains.jps.model.runConfiguration.JpsRunConfigurationType;
import org.jetbrains.jps.model.runConfiguration.JpsTypedRunConfiguration;

public class FlexBuildTargetType
extends BuildTargetType<FlexBuildTarget> {
    public static final FlexBuildTargetType INSTANCE = new FlexBuildTargetType();

    private FlexBuildTargetType() {
        super("flex");
    }

    @NotNull
    public List<FlexBuildTarget> computeAllTargets(@NotNull JpsModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/flex/build/FlexBuildTargetType", "computeAllTargets"));
        }
        ArrayList<FlexBuildTarget> result = new ArrayList<FlexBuildTarget>();
        JpsProject project = model.getProject();
        for (JpsTypedRunConfiguration runConfig : project.getRunConfigurations((JpsRunConfigurationType)JpsFlashRunConfigurationType.INSTANCE)) {
            ContainerUtilRt.addIfNotNull(result, (Object)((Object)FlexBuildTarget.create(project, runConfig.getType(), runConfig.getName())));
        }
        for (JpsTypedRunConfiguration runConfig : project.getRunConfigurations((JpsRunConfigurationType)JpsFlexUnitRunConfigurationType.INSTANCE)) {
            ContainerUtilRt.addIfNotNull(result, (Object)((Object)FlexBuildTarget.create(project, runConfig.getType(), runConfig.getName())));
        }
        for (JpsTypedModule module : project.getModules((JpsModuleType)JpsFlexModuleType.INSTANCE)) {
            for (JpsFlexBuildConfiguration bc : ((JpsFlexBuildConfigurationManager)module.getProperties()).getBuildConfigurations()) {
                result.add(FlexBuildTarget.create(bc, null));
                BuildConfigurationNature nature = bc.getNature();
                if (!nature.isApp() || !nature.isDesktopPlatform() && !nature.isMobilePlatform()) continue;
                result.add(FlexBuildTarget.create(bc, Boolean.TRUE));
                result.add(FlexBuildTarget.create(bc, Boolean.FALSE));
            }
        }
        ArrayList<FlexBuildTarget> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/build/FlexBuildTargetType", "computeAllTargets"));
        }
        return arrayList;
    }

    @NotNull
    public BuildTargetLoader<FlexBuildTarget> createLoader(@NotNull JpsModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/flex/build/FlexBuildTargetType", "createLoader"));
        }
        FlexBuildTargetLoader flexBuildTargetLoader = new FlexBuildTargetLoader(model);
        if (flexBuildTargetLoader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/build/FlexBuildTargetType", "createLoader"));
        }
        return flexBuildTargetLoader;
    }

    private static class FlexBuildTargetLoader
    extends BuildTargetLoader<FlexBuildTarget> {
        private final JpsModel myModel;

        public FlexBuildTargetLoader(JpsModel model) {
            this.myModel = model;
        }

        @Nullable
        public FlexBuildTarget createTarget(@NotNull String buildTargetId) {
            if (buildTargetId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildTargetId", "com/intellij/flex/build/FlexBuildTargetType$FlexBuildTargetLoader", "createTarget"));
            }
            JpsProject project = this.myModel.getProject();
            Pair<String, String> runConfigTypeIdAndName = FlexCommonUtils.getRunConfigTypeIdAndNameByBuildTargetId(buildTargetId);
            if (runConfigTypeIdAndName != null) {
                String runConfigTypeId = (String)runConfigTypeIdAndName.first;
                String runConfigName = (String)runConfigTypeIdAndName.second;
                if ("FlashRunConfigurationType".equals(runConfigTypeId)) {
                    return FlexBuildTarget.create(project, JpsFlashRunConfigurationType.INSTANCE, runConfigName);
                }
                if ("FlexUnitRunConfigurationType".equals(runConfigTypeId)) {
                    return FlexBuildTarget.create(project, JpsFlexUnitRunConfigurationType.INSTANCE, runConfigName);
                }
            } else {
                Trinity<String, String, Boolean> moduleAndBCNameAndForcedDebugStatus = FlexCommonUtils.getModuleAndBCNameAndForcedDebugStatusByBuildTargetId(buildTargetId);
                if (moduleAndBCNameAndForcedDebugStatus != null) {
                    String moduleName = (String)moduleAndBCNameAndForcedDebugStatus.first;
                    String bcName = (String)moduleAndBCNameAndForcedDebugStatus.second;
                    Boolean forcedDebugStatus = (Boolean)moduleAndBCNameAndForcedDebugStatus.third;
                    for (JpsTypedModule module : project.getModules((JpsModuleType)JpsFlexModuleType.INSTANCE)) {
                        if (!module.getName().equals(moduleName)) continue;
                        JpsFlexBuildConfiguration bc = ((JpsFlexBuildConfigurationManager)module.getProperties()).findConfigurationByName(bcName);
                        return bc != null ? FlexBuildTarget.create(bc, forcedDebugStatus) : null;
                    }
                }
            }
            return null;
        }
    }
}

