/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.flex.build;

import com.intellij.flex.FlexCommonUtils;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.THashMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public class AirDescriptorOptions {
    public static final int ANDROID_PERMISSION_INTERNET = 1;
    public static final int ANDROID_PERMISSION_WRITE_EXTERNAL_STORAGE = 2;
    public static final int ANDROID_PERMISSION_ACCESS_FINE_LOCATION = 4;
    public static final int ANDROID_PERMISSION_CAMERA = 8;
    public final String AIR_VERSION;
    public final String APP_ID;
    public final String APP_NAME;
    public final String APP_VERSION;
    public final String SWF_NAME;
    public final String[] EXTENSIONS;
    public final boolean MOBILE;
    public final boolean AUTO_ORIENTS;
    public final boolean FULL_SCREEN;
    public final boolean ANDROID;
    public final int ANDROID_PERMISSIONS;
    public final boolean IOS;
    public final boolean IPHONE;
    public final boolean IPAD;
    public final boolean IOS_HIGH_RESOLUTION;

    public AirDescriptorOptions(String airVersion, String appId, String appName, String swfName, String[] extensions, boolean android, boolean ios) {
        this(airVersion, appId, appName, "0.0.0", swfName, extensions, android || ios, android || ios, android || ios, android, 1, ios, ios, ios, ios);
    }

    public AirDescriptorOptions(String airVersion, String appId, String appName, String appVersion, String swfName, String[] extensions, boolean mobile, boolean autoOrients, boolean fullScreen, boolean android, int androidPermissions, boolean ios, boolean iPhone, boolean iPad, boolean iosHighResolution) {
        this.AIR_VERSION = airVersion;
        this.APP_ID = appId;
        this.APP_NAME = appName;
        this.APP_VERSION = appVersion;
        this.SWF_NAME = swfName;
        this.EXTENSIONS = extensions;
        this.MOBILE = mobile;
        this.AUTO_ORIENTS = autoOrients;
        this.FULL_SCREEN = fullScreen;
        this.ANDROID = android;
        this.ANDROID_PERMISSIONS = androidPermissions;
        this.IOS = ios;
        this.IPHONE = iPhone;
        this.IPAD = iPad;
        this.IOS_HIGH_RESOLUTION = iosHighResolution;
    }

    public String getAirDescriptorText() throws IOException {
        String rawText = FileUtil.loadTextAndClose((InputStream)AirDescriptorOptions.class.getResourceAsStream("air_descriptor_template.ft"));
        return this.replaceMacros(rawText);
    }

    private String replaceMacros(String descriptorText) {
        THashMap replacementMap = new THashMap();
        replacementMap.put("${air_version}", this.AIR_VERSION);
        replacementMap.put("${app_id}", this.APP_ID);
        replacementMap.put("${app_name}", this.APP_NAME);
        boolean air25OrLater = StringUtil.compareVersionNumbers((String)this.AIR_VERSION, (String)"2.5") >= 0;
        replacementMap.put("${app_version}", this.APP_VERSION);
        replacementMap.put("${version_number_comment_start}", air25OrLater ? "" : "<!--");
        replacementMap.put("${version_number_comment_end}", air25OrLater ? "" : "-->");
        replacementMap.put("${version_comment_start}", air25OrLater ? "<!--" : "");
        replacementMap.put("${version_comment_end}", air25OrLater ? "-->" : "");
        replacementMap.put("${swf_name}", this.SWF_NAME);
        if (this.EXTENSIONS.length == 0) {
            replacementMap.put("${extensions_comment_start}", "<!--");
            replacementMap.put("${extensions_comment_end}", "-->");
            replacementMap.put("${extensions_list}", "<extensionID></extensionID>");
        } else {
            StringBuilder buf = new StringBuilder();
            for (String extensionId : this.EXTENSIONS) {
                if (buf.length() > 0) {
                    buf.append("\n        ");
                }
                buf.append("<extensionID>").append(extensionId).append("</extensionID>");
            }
            replacementMap.put("${extensions_comment_start}", "");
            replacementMap.put("${extensions_comment_end}", "");
            replacementMap.put("${extensions_list}", buf.toString());
        }
        replacementMap.put("${auto_orients}", this.MOBILE ? String.valueOf(this.AUTO_ORIENTS) : "");
        replacementMap.put("${auto_orients_comment_start}", this.MOBILE ? "" : "<!--");
        replacementMap.put("${auto_orients_comment_end}", this.MOBILE ? "" : "-->");
        replacementMap.put("${full_screen}", this.MOBILE ? String.valueOf(this.FULL_SCREEN) : "");
        replacementMap.put("${full_screen_comment_start}", this.MOBILE ? "" : "<!--");
        replacementMap.put("${full_screen_comment_end}", this.MOBILE ? "" : "-->");
        replacementMap.put("${iOS_comment_start}", this.MOBILE && this.IOS ? "" : "<!--");
        replacementMap.put("${iOS_comment_end}", this.MOBILE && this.IOS ? "" : "-->");
        replacementMap.put("${iPhone_comment_start}", this.MOBILE && this.IOS && this.IPHONE ? "" : "<!--");
        replacementMap.put("${iPhone_comment_end}", this.MOBILE && this.IOS && this.IPHONE ? "" : "-->");
        replacementMap.put("${iPad_comment_start}", this.MOBILE && this.IOS && this.IPAD ? "" : "<!--");
        replacementMap.put("${iPad_comment_end}", this.MOBILE && this.IOS && this.IPAD ? "" : "-->");
        replacementMap.put("${iOS_high_resolution_comment_start}", this.MOBILE && this.IOS && this.IOS_HIGH_RESOLUTION ? "" : "<!--");
        replacementMap.put("${iOS_high_resolution_comment_end}", this.MOBILE && this.IOS && this.IOS_HIGH_RESOLUTION ? "" : "-->");
        replacementMap.put("${android_comment_start}", this.MOBILE && this.ANDROID ? "" : "<!--");
        replacementMap.put("${android_comment_end}", this.MOBILE && this.ANDROID ? "" : "-->");
        replacementMap.put("${android_internet_comment_start}", this.MOBILE && this.ANDROID && (this.ANDROID_PERMISSIONS & 1) != 0 ? "" : "<!--");
        replacementMap.put("${android_internet_comment_end}", this.MOBILE && this.ANDROID && (this.ANDROID_PERMISSIONS & 1) != 0 ? "" : "-->");
        replacementMap.put("${android_write_external_storage_comment_start}", this.MOBILE && this.ANDROID && (this.ANDROID_PERMISSIONS & 2) != 0 ? "" : "<!--");
        replacementMap.put("${android_write_external_storage_comment_end}", this.MOBILE && this.ANDROID && (this.ANDROID_PERMISSIONS & 2) != 0 ? "" : "-->");
        replacementMap.put("${android_access_fine_location_comment_start}", this.MOBILE && this.ANDROID && (this.ANDROID_PERMISSIONS & 4) != 0 ? "" : "<!--");
        replacementMap.put("${android_access_fine_location_comment_end}", this.MOBILE && this.ANDROID && (this.ANDROID_PERMISSIONS & 4) != 0 ? "" : "-->");
        replacementMap.put("${android_camera_comment_start}", this.MOBILE && this.ANDROID && (this.ANDROID_PERMISSIONS & 8) != 0 ? "" : "<!--");
        replacementMap.put("${android_camera_comment_end}", this.MOBILE && this.ANDROID && (this.ANDROID_PERMISSIONS & 8) != 0 ? "" : "-->");
        return FlexCommonUtils.replace(descriptorText, (Map<String, String>)replacementMap);
    }
}

