/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.utils;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.psi.tree.IElementType;
import java.util.HashMap;
import java.util.Map;

public class ParenthesesUtils {
    private static final int PARENTHESIZED_PRECEDENCE = 0;
    private static final int LITERAL_PRECEDENCE = 0;
    public static final int METHOD_CALL_PRECEDENCE = 1;
    private static final int POSTFIX_PRECEDENCE = 2;
    public static final int PREFIX_PRECEDENCE = 3;
    public static final int TYPE_CAST_PRECEDENCE = 4;
    public static final int MULTIPLICATIVE_PRECEDENCE = 5;
    private static final int ADDITIVE_PRECEDENCE = 6;
    public static final int SHIFT_PRECEDENCE = 7;
    private static final int RELATIONAL_PRECEDENCE = 8;
    private static final int EQUALITY_PRECEDENCE = 9;
    private static final int BINARY_AND_PRECEDENCE = 10;
    private static final int BINARY_XOR_PRECEDENCE = 11;
    private static final int BINARY_OR_PRECEDENCE = 12;
    public static final int AND_PRECEDENCE = 13;
    public static final int OR_PRECEDENCE = 14;
    public static final int CONDITIONAL_PRECEDENCE = 15;
    private static final int ASSIGNMENT_PRECEDENCE = 16;
    private static final int NUM_PRECEDENCES = 17;
    private static final Map<IElementType, Integer> s_binaryOperatorPrecedence = new HashMap<IElementType, Integer>(17);

    private ParenthesesUtils() {
    }

    public static int getPrecendence(JSExpression exp) {
        if (exp instanceof JSThisExpression || exp instanceof JSLiteralExpression || exp instanceof JSObjectLiteralExpression || exp instanceof JSArrayLiteralExpression || exp instanceof JSIndexedPropertyAccessExpression) {
            return 0;
        }
        if (exp instanceof JSReferenceExpression) {
            if (((JSReferenceExpression)exp).getQualifier() != null) {
                return 1;
            }
            return 0;
        }
        if (exp instanceof JSCallExpression) {
            return 1;
        }
        if (exp instanceof JSPrefixExpression) {
            return 3;
        }
        if (exp instanceof JSPostfixExpression) {
            return 2;
        }
        if (exp instanceof JSBinaryExpression && !(exp instanceof JSAssignmentExpression)) {
            IElementType sign = ((JSBinaryExpression)exp).getOperationSign();
            return ParenthesesUtils.precedenceForBinaryOperator(sign);
        }
        if (exp instanceof JSConditionalExpression) {
            return 15;
        }
        if (exp instanceof JSAssignmentExpression) {
            return 16;
        }
        if (exp instanceof JSParenthesizedExpression) {
            return 0;
        }
        return -1;
    }

    private static int precedenceForBinaryOperator(IElementType sign) {
        if (s_binaryOperatorPrecedence.containsKey(sign)) {
            return s_binaryOperatorPrecedence.get(sign);
        }
        return 16;
    }

    public static JSExpression stripExpression(JSExpression expression) {
        JSExpression workingExpression = expression;
        while (workingExpression instanceof JSParenthesizedExpression) {
            JSParenthesizedExpression parenthesizedExpression = (JSParenthesizedExpression)workingExpression;
            workingExpression = parenthesizedExpression.getInnerExpression();
        }
        return workingExpression;
    }

    public static JSExpression stripParentheses(JSExpression exp) {
        JSExpression parenthesized = exp;
        while (parenthesized instanceof JSParenthesizedExpression) {
            parenthesized = ((JSParenthesizedExpression)parenthesized).getInnerExpression();
        }
        return parenthesized;
    }

    static {
        s_binaryOperatorPrecedence.put(JSTokenTypes.PLUS, 6);
        s_binaryOperatorPrecedence.put(JSTokenTypes.MINUS, 6);
        s_binaryOperatorPrecedence.put(JSTokenTypes.MULT, 5);
        s_binaryOperatorPrecedence.put(JSTokenTypes.DIV, 5);
        s_binaryOperatorPrecedence.put(JSTokenTypes.PERC, 5);
        s_binaryOperatorPrecedence.put(JSTokenTypes.ANDAND, 13);
        s_binaryOperatorPrecedence.put(JSTokenTypes.OROR, 14);
        s_binaryOperatorPrecedence.put(JSTokenTypes.AND, 10);
        s_binaryOperatorPrecedence.put(JSTokenTypes.OR, 12);
        s_binaryOperatorPrecedence.put(JSTokenTypes.XOR, 11);
        s_binaryOperatorPrecedence.put(JSTokenTypes.LTLT, 7);
        s_binaryOperatorPrecedence.put(JSTokenTypes.GTGT, 7);
        s_binaryOperatorPrecedence.put(JSTokenTypes.GTGTGT, 7);
        s_binaryOperatorPrecedence.put(JSTokenTypes.GT, 8);
        s_binaryOperatorPrecedence.put(JSTokenTypes.GE, 8);
        s_binaryOperatorPrecedence.put(JSTokenTypes.LT, 8);
        s_binaryOperatorPrecedence.put(JSTokenTypes.LE, 8);
        s_binaryOperatorPrecedence.put(JSTokenTypes.EQEQ, 9);
        s_binaryOperatorPrecedence.put(JSTokenTypes.EQEQEQ, 9);
        s_binaryOperatorPrecedence.put(JSTokenTypes.NE, 9);
        s_binaryOperatorPrecedence.put(JSTokenTypes.NEQEQ, 9);
    }
}

