/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.utils;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.psi.tree.IElementType;
import com.sixrr.inspectjs.utils.ComparisonUtils;
import com.sixrr.inspectjs.utils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public class BoolUtils {
    private BoolUtils() {
    }

    public static boolean isNegation(@NotNull JSExpression exp) {
        if (exp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exp", "com/sixrr/inspectjs/utils/BoolUtils", "isNegation"));
        }
        if (!(exp instanceof JSPrefixExpression)) {
            return false;
        }
        JSPrefixExpression prefixExp = (JSPrefixExpression)exp;
        IElementType sign = prefixExp.getOperationSign();
        return JSTokenTypes.EXCL.equals(sign);
    }

    public static String getNegatedExpressionText(@NotNull JSExpression condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/sixrr/inspectjs/utils/BoolUtils", "getNegatedExpressionText"));
        }
        if (condition instanceof JSParenthesizedExpression) {
            JSExpression contentExpression = ((JSParenthesizedExpression)condition).getInnerExpression();
            return '(' + BoolUtils.getNegatedExpressionText(contentExpression) + ')';
        }
        if (BoolUtils.isNegation(condition)) {
            JSExpression negated = BoolUtils.getNegated(condition);
            return negated.getText();
        }
        if (ComparisonUtils.isComparison(condition)) {
            JSBinaryExpression binaryExpression = (JSBinaryExpression)condition;
            IElementType sign = binaryExpression.getOperationSign();
            String negatedComparison = ComparisonUtils.getNegatedComparison(sign);
            JSExpression lhs = binaryExpression.getLOperand();
            JSExpression rhs = binaryExpression.getROperand();
            if (rhs == null) {
                return lhs.getText() + negatedComparison;
            }
            return lhs.getText() + negatedComparison + rhs.getText();
        }
        if (ParenthesesUtils.getPrecendence(condition) > 3) {
            return "!(" + condition.getText() + ')';
        }
        return '!' + condition.getText();
    }

    private static JSExpression getNegated(@NotNull JSExpression exp) {
        if (exp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exp", "com/sixrr/inspectjs/utils/BoolUtils", "getNegated"));
        }
        JSPrefixExpression prefixExp = (JSPrefixExpression)exp;
        JSExpression operand = prefixExp.getExpression();
        return ParenthesesUtils.stripParentheses(operand);
    }

    public static boolean isBoolean(@NotNull JSExpression exp) {
        if (exp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exp", "com/sixrr/inspectjs/utils/BoolUtils", "isBoolean"));
        }
        return JSResolveUtil.getExpressionJSType(exp) instanceof JSBooleanType;
    }
}

