/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.functionmetrics;

import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSTryStatement;
import com.intellij.lang.javascript.psi.JSWhileStatement;
import org.jetbrains.annotations.NotNull;

class NestingDepthVisitor
extends JSRecursiveElementVisitor {
    private int m_maximumDepth = 0;
    private int m_currentDepth = 0;

    NestingDepthVisitor() {
    }

    public void visitJSDoWhileStatement(@NotNull JSDoWhileStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/sixrr/inspectjs/functionmetrics/NestingDepthVisitor", "visitJSDoWhileStatement"));
        }
        this.enterScope();
        super.visitJSDoWhileStatement(statement);
        this.exitScope();
    }

    public void visitJSForStatement(@NotNull JSForStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/sixrr/inspectjs/functionmetrics/NestingDepthVisitor", "visitJSForStatement"));
        }
        this.enterScope();
        super.visitJSForStatement(statement);
        this.exitScope();
    }

    public void visitJSIfStatement(@NotNull JSIfStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/sixrr/inspectjs/functionmetrics/NestingDepthVisitor", "visitJSIfStatement"));
        }
        boolean isAlreadyCounted = false;
        if (statement.getParent() instanceof JSIfStatement) {
            JSIfStatement parent = (JSIfStatement)statement.getParent();
            assert (parent != null);
            JSStatement elseBranch = parent.getElse();
            if (statement.equals(elseBranch)) {
                isAlreadyCounted = true;
            }
        }
        if (!isAlreadyCounted) {
            this.enterScope();
        }
        super.visitJSIfStatement(statement);
        if (!isAlreadyCounted) {
            this.exitScope();
        }
    }

    public void visitJSTryStatement(@NotNull JSTryStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/sixrr/inspectjs/functionmetrics/NestingDepthVisitor", "visitJSTryStatement"));
        }
        this.enterScope();
        super.visitJSTryStatement(statement);
        this.exitScope();
    }

    public void visitJSSwitchStatement(@NotNull JSSwitchStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/sixrr/inspectjs/functionmetrics/NestingDepthVisitor", "visitJSSwitchStatement"));
        }
        this.enterScope();
        super.visitJSSwitchStatement(statement);
        this.exitScope();
    }

    public void visitJSWhileStatement(@NotNull JSWhileStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/sixrr/inspectjs/functionmetrics/NestingDepthVisitor", "visitJSWhileStatement"));
        }
        this.enterScope();
        super.visitJSWhileStatement(statement);
        this.exitScope();
    }

    private void enterScope() {
        ++this.m_currentDepth;
        this.m_maximumDepth = Math.max(this.m_maximumDepth, this.m_currentDepth);
    }

    private void exitScope() {
        --this.m_currentDepth;
    }

    public int getMaximumDepth() {
        return this.m_maximumDepth;
    }
}

