/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.functionmetrics;

import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSWhileStatement;
import org.jetbrains.annotations.NotNull;

class LoopCountVisitor
extends JSRecursiveElementVisitor {
    private int loopCount = 0;

    LoopCountVisitor() {
    }

    public void visitJSElement(JSElement jsElement) {
        int oldCount = 0;
        if (jsElement instanceof JSFunction) {
            oldCount = this.loopCount;
        }
        super.visitJSElement(jsElement);
        if (jsElement instanceof JSFunction) {
            this.loopCount = oldCount;
        }
    }

    public void visitJSForStatement(@NotNull JSForStatement jsForStatement) {
        if (jsForStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsForStatement", "com/sixrr/inspectjs/functionmetrics/LoopCountVisitor", "visitJSForStatement"));
        }
        super.visitJSForStatement(jsForStatement);
        ++this.loopCount;
    }

    public void visitJSForInStatement(@NotNull JSForInStatement jsForStatement) {
        if (jsForStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsForStatement", "com/sixrr/inspectjs/functionmetrics/LoopCountVisitor", "visitJSForInStatement"));
        }
        super.visitJSForInStatement(jsForStatement);
        ++this.loopCount;
    }

    public void visitJSWhileStatement(@NotNull JSWhileStatement jsWhileStatement) {
        if (jsWhileStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsWhileStatement", "com/sixrr/inspectjs/functionmetrics/LoopCountVisitor", "visitJSWhileStatement"));
        }
        super.visitJSWhileStatement(jsWhileStatement);
        ++this.loopCount;
    }

    public void visitJSDoWhileStatement(@NotNull JSDoWhileStatement jsDoWhileStatement) {
        if (jsDoWhileStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsDoWhileStatement", "com/sixrr/inspectjs/functionmetrics/LoopCountVisitor", "visitJSDoWhileStatement"));
        }
        super.visitJSDoWhileStatement(jsDoWhileStatement);
        ++this.loopCount;
    }

    public int getCount() {
        return this.loopCount;
    }
}

