/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.functionmetrics;

import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import com.sixrr.inspectjs.functionmetrics.LoopCountVisitor;
import org.jetbrains.annotations.NotNull;

public class FunctionWithMultipleLoopsJSInspection
extends JavaScriptInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("function.with.multiple.loops.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/functionmetrics/FunctionWithMultipleLoopsJSInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.FUNCTIONMETRICS_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/functionmetrics/FunctionWithMultipleLoopsJSInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    public String buildErrorString(Object ... args) {
        JSFunction function = (JSFunction)((PsiElement)args[0]).getParent();
        assert (function != null);
        LoopCountVisitor visitor = new LoopCountVisitor();
        PsiElement lastChild = function.getLastChild();
        assert (lastChild != null);
        lastChild.accept((PsiElementVisitor)visitor);
        int loopCount = visitor.getCount();
        if (this.functionHasIdentifier(function)) {
            return InspectionJSBundle.message("function.contains.multiple.loops.error.string", loopCount);
        }
        return InspectionJSBundle.message("anonymous.function.contains.multiple.loops.error.string", loopCount);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSFunctionDeclaration(@NotNull JSFunction function) {
            if (function == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/sixrr/inspectjs/functionmetrics/FunctionWithMultipleLoopsJSInspection$Visitor", "visitJSFunctionDeclaration"));
            }
            PsiElement lastChild = function.getLastChild();
            if (!(lastChild instanceof JSBlockStatement)) {
                return;
            }
            LoopCountVisitor visitor = new LoopCountVisitor();
            lastChild.accept((PsiElementVisitor)visitor);
            int negationCount = visitor.getCount();
            if (negationCount <= 1) {
                return;
            }
            this.registerFunctionError(function);
        }

        @Override
        public void visitJSFunctionExpression(JSFunctionExpression node) {
            this.visitJSFunctionDeclaration((JSFunction)node);
        }
    }
}

