/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.control;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.psi.JSContinueStatement;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessaryLabelOnContinueStatementJSInspection
extends JavaScriptInspection
implements CleanupLocalInspectionTool {
    private final UnnecessaryLabelOnContinueStatementFix fix = new UnnecessaryLabelOnContinueStatementFix();

    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("unnecessary.label.on.continue.statement.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/UnnecessaryLabelOnContinueStatementJSInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.CONTROL_FLOW_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/UnnecessaryLabelOnContinueStatementJSInspection", "getGroupDisplayName"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return InspectionJSBundle.message("unnecessary.label.on.continue.error.string", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    @Override
    public InspectionJSFix buildFix(PsiElement location) {
        return this.fix;
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSContinueStatement(@NotNull JSContinueStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/sixrr/inspectjs/control/UnnecessaryLabelOnContinueStatementJSInspection$Visitor", "visitJSContinueStatement"));
            }
            super.visitJSContinueStatement(statement);
            if (statement.getLabel() == null) {
                return;
            }
            JSStatement statementToContinue = statement.getStatementToContinue();
            if (statementToContinue == null) {
                return;
            }
            JSLoopStatement containingLoop = (JSLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)statement, JSLoopStatement.class);
            if (containingLoop == null) {
                return;
            }
            PsiElement parent = containingLoop.getParent();
            if (!statementToContinue.equals(parent)) {
                return;
            }
            this.registerStatementError((JSStatement)statement, new Object[0]);
        }
    }

    private static class UnnecessaryLabelOnContinueStatementFix
    extends InspectionJSFix {
        private UnnecessaryLabelOnContinueStatementFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionJSBundle.message("remove.label.fix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/UnnecessaryLabelOnContinueStatementJSInspection$UnnecessaryLabelOnContinueStatementFix", "getName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement continueKeywordElement = descriptor.getPsiElement();
            JSContinueStatement continueStatement = (JSContinueStatement)continueKeywordElement.getParent();
            UnnecessaryLabelOnContinueStatementFix.replaceStatement((JSStatement)continueStatement, "continue;");
        }
    }
}

