/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.control;

import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSWhileStatement;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NotNull;

public class LoopStatementThatDoesntLoopJSInspection
extends JavaScriptInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("loop.statement.that.doesn.t.loop.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/LoopStatementThatDoesntLoopJSInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.CONTROL_FLOW_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/LoopStatementThatDoesntLoopJSInspection", "getGroupDisplayName"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public String buildErrorString(Object ... args) {
        return InspectionJSBundle.message("loop.statement.that.doesnt.loop.error.string", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSForStatement(@NotNull JSForStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/sixrr/inspectjs/control/LoopStatementThatDoesntLoopJSInspection$Visitor", "visitJSForStatement"));
            }
            super.visitJSForStatement(statement);
            JSStatement body = statement.getBody();
            if (body == null) {
                return;
            }
            if (ControlFlowUtils.statementMayCompleteNormally(body)) {
                return;
            }
            if (ControlFlowUtils.statementIsContinueTarget((JSStatement)statement)) {
                return;
            }
            this.registerStatementError((JSStatement)statement, new Object[0]);
        }

        public void visitJSForInStatement(@NotNull JSForInStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/sixrr/inspectjs/control/LoopStatementThatDoesntLoopJSInspection$Visitor", "visitJSForInStatement"));
            }
            super.visitJSForInStatement(statement);
            JSStatement body = statement.getBody();
            if (body == null) {
                return;
            }
            if (ControlFlowUtils.statementMayCompleteNormally(body)) {
                return;
            }
            if (ControlFlowUtils.statementIsContinueTarget((JSStatement)statement)) {
                return;
            }
            this.registerStatementError((JSStatement)statement, new Object[0]);
        }

        public void visitJSWhileStatement(@NotNull JSWhileStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/sixrr/inspectjs/control/LoopStatementThatDoesntLoopJSInspection$Visitor", "visitJSWhileStatement"));
            }
            super.visitJSWhileStatement(statement);
            JSStatement body = statement.getBody();
            if (body == null) {
                return;
            }
            if (ControlFlowUtils.statementMayCompleteNormally(body)) {
                return;
            }
            if (ControlFlowUtils.statementIsContinueTarget((JSStatement)statement)) {
                return;
            }
            this.registerStatementError((JSStatement)statement, new Object[0]);
        }

        public void visitJSDoWhileStatement(@NotNull JSDoWhileStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/sixrr/inspectjs/control/LoopStatementThatDoesntLoopJSInspection$Visitor", "visitJSDoWhileStatement"));
            }
            super.visitJSDoWhileStatement(statement);
            JSStatement body = statement.getBody();
            if (body == null) {
                return;
            }
            if (ControlFlowUtils.statementMayCompleteNormally(body)) {
                return;
            }
            if (ControlFlowUtils.statementIsContinueTarget((JSStatement)statement)) {
                return;
            }
            this.registerStatementError((JSStatement)statement, new Object[0]);
        }
    }
}

