/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.control;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleIntegerFieldOptionsPanel;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.psi.PsiElement;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class IfStatementWithTooManyBranchesJSInspection
extends JavaScriptInspection {
    private static final int DEFAULT_BRANCH_LIMIT = 3;
    public int m_limit = 3;

    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("if.statement.with.too.many.branches.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/IfStatementWithTooManyBranchesJSInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.CONTROL_FLOW_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/IfStatementWithTooManyBranchesJSInspection", "getGroupDisplayName"));
        }
        return string;
    }

    private int getLimit() {
        return this.m_limit;
    }

    public JComponent createOptionsPanel() {
        return new SingleIntegerFieldOptionsPanel(InspectionJSBundle.message("maximum.number.of.branches.parameter", new Object[0]), (InspectionProfileEntry)this, "m_limit");
    }

    @Override
    protected String buildErrorString(Object ... args) {
        JSIfStatement statement = (JSIfStatement)args[0];
        int branches = IfStatementWithTooManyBranchesJSInspection.calculateNumBranches(statement);
        return InspectionJSBundle.message("if.statement.with.too.many.branches.error.string", branches);
    }

    private static int calculateNumBranches(JSIfStatement statement) {
        JSStatement branch = statement.getElse();
        if (branch == null) {
            return 1;
        }
        if (!(branch instanceof JSIfStatement)) {
            return 2;
        }
        return 1 + IfStatementWithTooManyBranchesJSInspection.calculateNumBranches((JSIfStatement)branch);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSIfStatement(@NotNull JSIfStatement statement) {
            JSIfStatement parentStatement;
            JSStatement elseBranch;
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/sixrr/inspectjs/control/IfStatementWithTooManyBranchesJSInspection$Visitor", "visitJSIfStatement"));
            }
            super.visitJSIfStatement(statement);
            PsiElement parent = statement.getParent();
            if (parent instanceof JSIfStatement && statement.equals(elseBranch = (parentStatement = (JSIfStatement)parent).getElse())) {
                return;
            }
            int branches = IfStatementWithTooManyBranchesJSInspection.calculateNumBranches(statement);
            if (branches <= IfStatementWithTooManyBranchesJSInspection.this.getLimit()) {
                return;
            }
            this.registerStatementError((JSStatement)statement, statement);
        }
    }
}

