/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.confusing;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import com.sixrr.inspectjs.utils.BoolUtils;
import com.sixrr.inspectjs.utils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NegatedIfStatementJSInspection
extends JavaScriptInspection {
    private final NegatedIfElseFix fix = new NegatedIfElseFix();

    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("negated.if.statement.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/confusing/NegatedIfStatementJSInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.CONFUSING_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/confusing/NegatedIfStatementJSInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return InspectionJSBundle.message("negated.ref.statement.error.string", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    @Override
    protected InspectionJSFix buildFix(PsiElement location) {
        return this.fix;
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSIfStatement(JSIfStatement statement) {
            JSIfStatement parentStatement;
            JSStatement elseBranch;
            super.visitJSIfStatement(statement);
            PsiElement parent = statement.getParent();
            if (parent instanceof JSIfStatement && statement.equals(elseBranch = (parentStatement = (JSIfStatement)parent).getElse())) {
                return;
            }
            JSStatement elseStatement = statement.getElse();
            if (elseStatement == null) {
                return;
            }
            JSExpression condition = statement.getCondition();
            if ((condition = ParenthesesUtils.stripExpression(condition)) == null || !BoolUtils.isNegation(condition) && !this.isNotEquals(condition)) {
                return;
            }
            if (elseStatement instanceof JSIfStatement) {
                JSExpression elseCondition = ((JSIfStatement)elseStatement).getCondition();
                if ((elseCondition = ParenthesesUtils.stripExpression(elseCondition)) != null && (BoolUtils.isNegation(elseCondition) || this.isNotEquals(condition))) {
                    return;
                }
            }
            this.registerStatementError((JSStatement)statement, new Object[0]);
        }

        private boolean isNotEquals(JSExpression expression) {
            if (!(expression instanceof JSBinaryExpression)) {
                return false;
            }
            JSBinaryExpression binaryExpression = (JSBinaryExpression)expression;
            IElementType sign = binaryExpression.getOperationSign();
            return JSTokenTypes.NE.equals(sign) || JSTokenTypes.NEQEQ.equals(sign);
        }
    }

    private static class NegatedIfElseFix
    extends InspectionJSFix {
        private NegatedIfElseFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionJSBundle.message("invert.if.condition.fix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/confusing/NegatedIfStatementJSInspection$NegatedIfElseFix", "getName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiComment comment;
            IElementType tokenType;
            PsiElement ifToken = descriptor.getPsiElement();
            JSIfStatement ifStatement = (JSIfStatement)ifToken.getParent();
            assert (ifStatement != null);
            JSStatement elseBranch = ifStatement.getElse();
            JSStatement thenBranch = ifStatement.getThen();
            JSExpression condition = ifStatement.getCondition();
            String negatedCondition = BoolUtils.getNegatedExpressionText(condition);
            String elseText = elseBranch.getText();
            PsiElement lastChild = elseBranch.getLastChild();
            if (lastChild instanceof PsiComment && JSTokenTypes.END_OF_LINE_COMMENT.equals(tokenType = (comment = (PsiComment)lastChild).getTokenType())) {
                elseText = elseText + '\n';
            }
            if (!(elseBranch instanceof JSBlockStatement)) {
                elseText = "{\n" + elseText + "\n}";
            }
            String newStatement = "if(" + negatedCondition + ')' + elseText + " else " + thenBranch.getText();
            NegatedIfElseFix.replaceStatement((JSStatement)ifStatement, newStatement);
        }
    }
}

