/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.bugs;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NotNull;

public class EqualityComparisonWithCoercionJSInspection
extends JavaScriptInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("equality.comparison.with.coercion.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/bugs/EqualityComparisonWithCoercionJSInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.BUGS_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/bugs/EqualityComparisonWithCoercionJSInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... args) {
        String string = InspectionJSBundle.message("equality.comparison.with.coercion.error.string", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/bugs/EqualityComparisonWithCoercionJSInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected InspectionJSFix buildFix(PsiElement location) {
        JSBinaryExpression expression = (JSBinaryExpression)location;
        IElementType sign = expression.getOperationSign();
        if (JSTokenTypes.EQEQ == sign) {
            return new EqualityComparisonWithCoercionFix("===");
        }
        if (JSTokenTypes.NE == sign) {
            return new EqualityComparisonWithCoercionFix("!==");
        }
        return null;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new EqualityComparisonWithCoercionVisitor();
    }

    private static boolean mayCauseCoercion(JSExpression expression) {
        String text = expression.getText();
        return "0".equals(text) || "0x0".equals(text) || "0X0".equals(text) || "0.0".equals(text) || "0L".equals(text) || "0l".equals(text) || "null".equals(text) || "undefined".equals(text) || "true".equals(text) || "false".equals(text) || "''".equals(text);
    }

    private static class EqualityComparisonWithCoercionVisitor
    extends BaseInspectionVisitor {
        private EqualityComparisonWithCoercionVisitor() {
        }

        public void visitJSBinaryExpression(@NotNull JSBinaryExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/sixrr/inspectjs/bugs/EqualityComparisonWithCoercionJSInspection$EqualityComparisonWithCoercionVisitor", "visitJSBinaryExpression"));
            }
            super.visitJSBinaryExpression(expression);
            JSExpression lhs = expression.getLOperand();
            if (lhs == null) {
                return;
            }
            JSExpression rhs = expression.getROperand();
            if (rhs == null) {
                return;
            }
            IElementType tokenType = expression.getOperationSign();
            if (!JSTokenTypes.EQEQ.equals(tokenType) && !JSTokenTypes.NE.equals(tokenType)) {
                return;
            }
            if (!EqualityComparisonWithCoercionJSInspection.mayCauseCoercion(rhs) && !EqualityComparisonWithCoercionJSInspection.mayCauseCoercion(lhs)) {
                return;
            }
            this.registerError((PsiElement)expression);
        }
    }

    private static class EqualityComparisonWithCoercionFix
    extends InspectionJSFix {
        private final String sign;

        public EqualityComparisonWithCoercionFix(String sign) {
            this.sign = sign;
        }

        @NotNull
        public String getName() {
            String string = InspectionJSBundle.message("equality.comparison.with.coercion.fix", this.sign);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/bugs/EqualityComparisonWithCoercionJSInspection$EqualityComparisonWithCoercionFix", "getName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            JSBinaryExpression expression = (JSBinaryExpression)descriptor.getPsiElement();
            JSExpression lhs = expression.getLOperand();
            JSExpression rhs = expression.getROperand();
            EqualityComparisonWithCoercionFix.replaceExpression((JSExpression)expression, lhs.getText() + this.sign + rhs.getText());
        }
    }
}

