/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.bitwise;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import com.sixrr.inspectjs.utils.ExpressionUtil;
import org.jetbrains.annotations.NotNull;

public class ShiftOutOfRangeJSInspection
extends JavaScriptInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("shift.operation.by.inappropriate.constant.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/bitwise/ShiftOutOfRangeJSInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.BITWISE_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/bitwise/ShiftOutOfRangeJSInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... args) {
        Integer value = (Integer)args[0];
        if (value > 0) {
            String string = InspectionJSBundle.message("shift.operation.by.inappropriate.constant.problem.descriptor.too.large", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/bitwise/ShiftOutOfRangeJSInspection", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionJSBundle.message("shift.operation.by.inappropriate.constant.problem.descriptor.negative", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/bitwise/ShiftOutOfRangeJSInspection", "buildErrorString"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ShiftOutOfRange();
    }

    private static class ShiftOutOfRange
    extends BaseInspectionVisitor {
        private ShiftOutOfRange() {
        }

        public void visitJSBinaryExpression(@NotNull JSBinaryExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/sixrr/inspectjs/bitwise/ShiftOutOfRangeJSInspection$ShiftOutOfRange", "visitJSBinaryExpression"));
            }
            super.visitJSBinaryExpression(expression);
            IElementType tokenType = expression.getOperationSign();
            if (tokenType == null || !tokenType.equals(JSTokenTypes.LTLT) && !tokenType.equals(JSTokenTypes.GTGT) && !tokenType.equals(JSTokenTypes.GTGTGT)) {
                return;
            }
            JSExpression rhs = expression.getROperand();
            if (rhs == null) {
                return;
            }
            if (!ExpressionUtil.isConstantExpression(rhs)) {
                return;
            }
            Object valueObject = ExpressionUtil.computeConstantExpression(rhs);
            if (!(valueObject instanceof Integer)) {
                return;
            }
            int value = (Integer)valueObject;
            if (value < 0 || value > 31) {
                this.registerError((PsiElement)expression, value);
            }
        }
    }
}

