/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.bitwise;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import com.sixrr.inspectjs.utils.ComparisonUtils;
import com.sixrr.inspectjs.utils.ExpressionUtil;
import com.sixrr.inspectjs.utils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public class IncompatibleMaskJSInspection
extends JavaScriptInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("incompatible.mask.operation.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/bitwise/IncompatibleMaskJSInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.BITWISE_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/bitwise/IncompatibleMaskJSInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... args) {
        JSBinaryExpression binaryExpression = (JSBinaryExpression)args[0];
        IElementType tokenType = binaryExpression.getOperationSign();
        if (JSTokenTypes.EQEQ.equals(tokenType)) {
            String string = InspectionJSBundle.message("incompatible.mask.operation.problem.descriptor.always.false", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/bitwise/IncompatibleMaskJSInspection", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionJSBundle.message("incompatible.mask.operation.problem.descriptor.always.true", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/bitwise/IncompatibleMaskJSInspection", "buildErrorString"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new IncompatibleMaskVisitor();
    }

    private static class IncompatibleMaskVisitor
    extends BaseInspectionVisitor {
        private IncompatibleMaskVisitor() {
        }

        public void visitJSBinaryExpression(@NotNull JSBinaryExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/sixrr/inspectjs/bitwise/IncompatibleMaskJSInspection$IncompatibleMaskVisitor", "visitJSBinaryExpression"));
            }
            super.visitJSBinaryExpression(expression);
            JSExpression rhs = expression.getROperand();
            if (!ComparisonUtils.isEqualityComparison(expression)) {
                return;
            }
            JSExpression strippedRhs = ParenthesesUtils.stripParentheses(rhs);
            if (strippedRhs == null) {
                return;
            }
            JSExpression lhs = expression.getLOperand();
            JSExpression strippedLhs = ParenthesesUtils.stripParentheses(lhs);
            if (strippedLhs == null) {
                return;
            }
            if (IncompatibleMaskVisitor.isConstantMask(strippedLhs) && ExpressionUtil.isConstantExpression(strippedRhs)) {
                if (IncompatibleMaskVisitor.isIncompatibleMask((JSBinaryExpression)strippedLhs, strippedRhs)) {
                    this.registerError((PsiElement)expression, expression);
                }
            } else if (IncompatibleMaskVisitor.isConstantMask(strippedRhs) && ExpressionUtil.isConstantExpression(strippedLhs) && IncompatibleMaskVisitor.isIncompatibleMask((JSBinaryExpression)strippedRhs, strippedLhs)) {
                this.registerError((PsiElement)expression, expression);
            }
        }

        private static boolean isIncompatibleMask(JSBinaryExpression maskExpression, JSExpression constantExpression) {
            int constantMaskValue;
            IElementType tokenType = maskExpression.getOperationSign();
            Object constantValue = ExpressionUtil.computeConstantExpression(constantExpression);
            if (!(constantValue instanceof Integer)) {
                return false;
            }
            int constantLongValue = (Integer)constantValue;
            JSExpression maskRhs = maskExpression.getROperand();
            JSExpression maskLhs = maskExpression.getLOperand();
            if (ExpressionUtil.isConstantExpression(maskRhs)) {
                Object rhsValue = ExpressionUtil.computeConstantExpression(maskRhs);
                if (!(rhsValue instanceof Integer)) {
                    return false;
                }
                constantMaskValue = (Integer)rhsValue;
            } else {
                Object lhsValue = ExpressionUtil.computeConstantExpression(maskLhs);
                if (!(lhsValue instanceof Integer)) {
                    return false;
                }
                constantMaskValue = (Integer)lhsValue;
            }
            if (JSTokenTypes.OR.equals(tokenType) && (constantMaskValue | constantLongValue) != constantLongValue) {
                return true;
            }
            return JSTokenTypes.AND.equals(tokenType) && (constantMaskValue | constantLongValue) != constantMaskValue;
        }

        private static boolean isConstantMask(JSExpression expression) {
            if (expression == null) {
                return false;
            }
            if (!(expression instanceof JSBinaryExpression)) {
                return false;
            }
            JSBinaryExpression binaryExpression = (JSBinaryExpression)expression;
            IElementType tokenType = binaryExpression.getOperationSign();
            if (!JSTokenTypes.OR.equals(tokenType) && !JSTokenTypes.AND.equals(tokenType)) {
                return false;
            }
            JSExpression rhs = binaryExpression.getROperand();
            if (ExpressionUtil.isConstantExpression(rhs)) {
                return true;
            }
            JSExpression lhs = binaryExpression.getLOperand();
            return ExpressionUtil.isConstantExpression(lhs);
        }
    }
}

